/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.Performance;
import adams.core.Properties;
import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import adams.multiprocess.WekaCrossValidationExecution;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instances;

public class CrossValidation
extends AbstractClassifierEvaluation
implements StoppableWithFeedback {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_FOLDS = "folds";
    public static final String KEY_SEED = "seed";
    public static final String KEY_THREADS = "threads";
    public static final String KEY_ADDITIONAL = "additional";
    public static final String KEY_USEVIEWS = "useviews";
    public static final String KEY_DISCARDPREDICTIONS = "discardpredictions";
    public static final String KEY_FINALMODEL = "finalmodel";
    protected ParameterPanel m_PanelParameters;
    protected JComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected JSpinner m_SpinnerFolds;
    protected NumberTextField m_TextSeed;
    protected JSpinner m_SpinnerThreads;
    protected SelectOptionPanel m_SelectAdditionalAttributes;
    protected JCheckBox m_CheckBoxUseViews;
    protected JCheckBox m_CheckBoxDiscardPredictions;
    protected JCheckBox m_CheckBoxFinalModel;
    protected WekaCrossValidationExecution m_CrossValidation;

    public String globalInfo() {
        return "Performs cross-validation.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CrossValidation = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = CrossValidation.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new JComboBox<String>(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_SpinnerFolds = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerFolds.getModel()).setMinimum(Integer.valueOf(-1));
        ((SpinnerNumberModel)this.m_SpinnerFolds.getModel()).setStepSize(1);
        this.m_SpinnerFolds.setValue(props.getInteger("Classify.NumFolds", Integer.valueOf(10)));
        this.m_SpinnerFolds.setToolTipText("The number of folds to use (< 2 for LOO-CV)");
        this.m_SpinnerFolds.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Folds", (Component)this.m_SpinnerFolds);
        this.m_TextSeed = new NumberTextField(NumberTextField.Type.INTEGER, "" + props.getInteger("Classify.Seed", Integer.valueOf(1)));
        this.m_TextSeed.setToolTipText("The seed value for randomizing the data");
        this.m_TextSeed.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Seed", (Component)this.m_TextSeed);
        this.m_SpinnerThreads = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerThreads.getModel()).setStepSize(1);
        this.m_SpinnerThreads.setValue(props.getInteger("Classify.NumThreads", Integer.valueOf(-1)));
        this.m_SpinnerThreads.setToolTipText(Performance.getNumThreadsHelp());
        this.m_SpinnerThreads.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Threads", (Component)this.m_SpinnerThreads);
        this.m_CheckBoxUseViews = new JCheckBox();
        this.m_CheckBoxUseViews.setSelected(props.getBoolean("Classify.UseViews", Boolean.valueOf(false)));
        this.m_CheckBoxUseViews.setToolTipText("Save memory by using views instead of creating copies of datasets?");
        this.m_CheckBoxUseViews.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Use views", (Component)this.m_CheckBoxUseViews);
        this.m_CheckBoxDiscardPredictions = new JCheckBox();
        this.m_CheckBoxDiscardPredictions.setSelected(props.getBoolean("Classify.DiscardPredictions", Boolean.valueOf(false)));
        this.m_CheckBoxDiscardPredictions.setToolTipText("Save memory by discarding predictions?");
        this.m_CheckBoxDiscardPredictions.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Discard predictions", (Component)this.m_CheckBoxDiscardPredictions);
        this.m_SelectAdditionalAttributes = new SelectOptionPanel();
        this.m_SelectAdditionalAttributes.setCurrent((Object)new String[0]);
        this.m_SelectAdditionalAttributes.setMultiSelect(true);
        this.m_SelectAdditionalAttributes.setLenient(true);
        this.m_SelectAdditionalAttributes.setDialogTitle("Select additional attributes");
        this.m_SelectAdditionalAttributes.setToolTipText("Additional attributes to make available in plots");
        this.m_PanelParameters.addParameter("Additional attributes", (Component)this.m_SelectAdditionalAttributes);
        this.m_CheckBoxFinalModel = new JCheckBox();
        this.m_CheckBoxFinalModel.setSelected(props.getBoolean("Classify.CrossValidationFinalModel", Boolean.valueOf(true)));
        this.m_CheckBoxFinalModel.setToolTipText("Produce a final model using the full training data?");
        this.m_CheckBoxFinalModel.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Final model", (Component)this.m_CheckBoxFinalModel);
    }

    @Override
    public String getName() {
        return "Cross-validation";
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        if (!Utils.isInteger((String)this.m_TextSeed.getText())) {
            return "Seed value is not an integer!";
        }
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Capabilities caps = classifier.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(classifier, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Classifier classifier, ResultItem item) throws Exception {
        String msg = this.canEvaluate(classifier);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate classifier!\n" + msg);
        }
        DataContainer dataCont = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        boolean finalModel = this.m_CheckBoxFinalModel.isSelected();
        boolean views = this.m_CheckBoxUseViews.isSelected();
        boolean discard = this.m_CheckBoxDiscardPredictions.isSelected();
        int seed = this.m_TextSeed.getValue().intValue();
        int folds = ((Number)this.m_SpinnerFolds.getValue()).intValue();
        int threads = ((Number)this.m_SpinnerThreads.getValue()).intValue();
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)classifier));
        runInfo.add("Seed", (Object)seed);
        runInfo.add("Folds", (Object)folds);
        runInfo.add("Threads", (Object)threads);
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        runInfo.add("Class attribute", (Object)data.classAttribute().name());
        runInfo.add("Use views", (Object)views);
        runInfo.add("Discard predictions", (Object)discard);
        if (((String[])this.m_SelectAdditionalAttributes.getCurrent()).length > 0) {
            runInfo.add("Additional attributes: ", (Object)Utils.flatten((Object[])((Object[])this.m_SelectAdditionalAttributes.getCurrent()), (String)", "));
        }
        this.m_CrossValidation = new WekaCrossValidationExecution();
        this.m_CrossValidation.setClassifier(classifier);
        this.m_CrossValidation.setData(data);
        this.m_CrossValidation.setFolds(folds);
        this.m_CrossValidation.setSeed(seed);
        this.m_CrossValidation.setNumThreads(threads);
        this.m_CrossValidation.setUseViews(views);
        this.m_CrossValidation.setDiscardPredictions(discard);
        this.m_CrossValidation.setStatusMessageHandler(this);
        msg = this.m_CrossValidation.execute();
        if (msg != null) {
            throw new Exception("Failed to cross-validate:\n" + msg);
        }
        Classifier model = null;
        if (finalModel) {
            ((ClassifyTab)this.getOwner()).logMessage("Building final model on '" + dataCont.getID() + "/" + data.relationName() + "' using " + OptionUtils.getCommandLine((Object)classifier));
            model = (Classifier)OptionUtils.shallowCopy((Object)classifier);
            model.buildClassifier(data);
            this.addObjectSize(runInfo, "Final model size", model);
        }
        item.update(this.m_CrossValidation.getEvaluation(), model, runInfo, this.m_CrossValidation.getOriginalIndices(), this.transferAdditionalAttributes(this.m_SelectAdditionalAttributes, data));
        this.m_CrossValidation = null;
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClassifyTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.fillWithAttributeNames(this.m_SelectAdditionalAttributes, this.m_ComboBoxDatasets.getSelectedIndex());
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    public void stopExecution() {
        if (this.m_CrossValidation != null) {
            this.m_CrossValidation.stopExecution();
        }
    }

    public boolean isStopped() {
        return this.m_CrossValidation != null && this.m_CrossValidation.isStopped();
    }

    @Override
    public Map<String, Object> serialize() {
        Map<String, Object> result = super.serialize();
        result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        result.put(KEY_FOLDS, this.m_SpinnerFolds.getValue());
        result.put(KEY_SEED, this.m_TextSeed.getValue().intValue());
        result.put(KEY_THREADS, this.m_SpinnerThreads.getValue());
        result.put(KEY_ADDITIONAL, this.m_SelectAdditionalAttributes.getCurrent());
        result.put(KEY_USEVIEWS, this.m_CheckBoxUseViews.isSelected());
        result.put(KEY_DISCARDPREDICTIONS, this.m_CheckBoxDiscardPredictions.isSelected());
        result.put(KEY_FINALMODEL, this.m_CheckBoxFinalModel.isSelected());
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex((Integer)data.get(KEY_DATASET));
        }
        if (data.containsKey(KEY_FOLDS)) {
            this.m_SpinnerFolds.setValue(data.get(KEY_FOLDS));
        }
        if (data.containsKey(KEY_SEED)) {
            this.m_TextSeed.setValue((Number)((Integer)data.get(KEY_SEED)));
        }
        if (data.containsKey(KEY_THREADS)) {
            this.m_SpinnerThreads.setValue(data.get(KEY_THREADS));
        }
        if (data.containsKey(KEY_ADDITIONAL)) {
            this.m_SelectAdditionalAttributes.setCurrent((Object)((String[])data.get(KEY_ADDITIONAL)));
        }
        if (data.containsKey(KEY_USEVIEWS)) {
            this.m_CheckBoxUseViews.setSelected((Boolean)data.get(KEY_USEVIEWS));
        }
        if (data.containsKey(KEY_DISCARDPREDICTIONS)) {
            this.m_CheckBoxDiscardPredictions.setSelected((Boolean)data.get(KEY_DISCARDPREDICTIONS));
        }
        if (data.containsKey(KEY_FINALMODEL)) {
            this.m_CheckBoxFinalModel.setSelected((Boolean)data.get(KEY_FINALMODEL));
        }
    }
}

