/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.Instances;

public class ReevaluateModel
extends AbstractClassifierEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_MODEL = "model";
    public static final String KEY_ADDITIONAL = "additional";
    public static final String KEY_DISCARDPREDICTIONS = "discardpredictions";
    protected ParameterPanel m_PanelParameters;
    protected JComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected SelectOptionPanel m_SelectAdditionalAttributes;
    protected JCheckBox m_CheckBoxDiscardPredictions;
    protected FileChooserPanel m_PanelModel;
    protected Classifier m_Model;
    protected Instances m_Header;

    public String globalInfo() {
        return "Re-evaluates a serialized model on a test set.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Model = null;
        this.m_Header = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = ReevaluateModel.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new JComboBox<String>(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_PanelModel = new FileChooserPanel();
        ExtensionFileFilter filter = ExtensionFileFilter.getModelFileFilter();
        this.m_PanelModel.addChoosableFileFilter((FileFilter)filter);
        this.m_PanelModel.setFileFilter((FileFilter)filter);
        this.m_PanelModel.setAcceptAllFileFilterUsed(true);
        this.m_PanelModel.addChangeListener(e -> this.loadModel());
        this.m_PanelParameters.addParameter("Model", (Component)this.m_PanelModel);
        this.m_SelectAdditionalAttributes = new SelectOptionPanel();
        this.m_SelectAdditionalAttributes.setCurrent((Object)new String[0]);
        this.m_SelectAdditionalAttributes.setMultiSelect(true);
        this.m_SelectAdditionalAttributes.setLenient(true);
        this.m_SelectAdditionalAttributes.setDialogTitle("Select additional attributes");
        this.m_SelectAdditionalAttributes.setToolTipText("Additional attributes to make available in plots");
        this.m_PanelParameters.addParameter("Additional attributes", (Component)this.m_SelectAdditionalAttributes);
        this.m_CheckBoxDiscardPredictions = new JCheckBox();
        this.m_CheckBoxDiscardPredictions.setSelected(props.getBoolean("Classify.DiscardPredictions", Boolean.valueOf(false)));
        this.m_CheckBoxDiscardPredictions.setToolTipText("Save memory by discarding predictions?");
        this.m_CheckBoxDiscardPredictions.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Discard predictions", (Component)this.m_CheckBoxDiscardPredictions);
    }

    @Override
    public String getName() {
        return "Re-evaluate model";
    }

    protected boolean loadModel() {
        this.m_Model = null;
        this.m_Header = null;
        File file = (File)this.m_PanelModel.getCurrent();
        if (file.isDirectory()) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        try {
            Object[] obj = SerializationHelper.readAll((String)file.getAbsolutePath());
            if (obj.length > 0) {
                this.m_Model = (Classifier)obj[0];
            }
            if (obj.length > 1) {
                this.m_Header = (Instances)obj[1];
            }
        }
        catch (Exception e) {
            this.showStatus("Failed to load model: " + file);
            return false;
        }
        return true;
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        File file = (File)this.m_PanelModel.getCurrent();
        if (file.isDirectory()) {
            return "Model points to directory: " + file;
        }
        if (!file.exists()) {
            return "Model does not exist: " + file;
        }
        if (this.m_Model == null) {
            this.loadModel();
        }
        if (this.m_Model == null) {
            return "Failed to load model: " + file;
        }
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        if (this.m_Header != null && !data.equalHeaders(this.m_Header)) {
            return data.equalHeadersMsg(this.m_Header);
        }
        Capabilities caps = this.m_Model.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(classifier, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Classifier classifier, ResultItem item) throws Exception {
        int i;
        classifier = (Classifier)OptionUtils.shallowCopy((Object)this.m_Model);
        String msg = this.canEvaluate(classifier);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate classifier!\n" + msg);
        }
        DataContainer dataCont = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        boolean discard = this.m_CheckBoxDiscardPredictions.isSelected();
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)this.m_Model));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        runInfo.add("Class attribute", (Object)data.classAttribute().name());
        runInfo.add("Discard predictions", (Object)discard);
        if (((String[])this.m_SelectAdditionalAttributes.getCurrent()).length > 0) {
            runInfo.add("Additional attributes: ", (Object)Utils.flatten((Object[])((Object[])this.m_SelectAdditionalAttributes.getCurrent()), (String)", "));
        }
        this.addObjectSize(runInfo, "Model size", this.m_Model);
        Evaluation eval = new Evaluation(data);
        eval.setDiscardPredictions(discard);
        int interval = this.getTestingUpdateInterval();
        for (i = 0; i < data.numInstances(); ++i) {
            eval.evaluateModelOnceAndRecordPrediction(this.m_Model, data.instance(i));
            if ((i + 1) % interval != 0) continue;
            ((ClassifyTab)this.getOwner()).logMessage("Used " + (i + 1) + "/" + data.numInstances() + " of '" + dataCont.getID() + "/" + data.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)classifier));
        }
        ((ClassifyTab)this.getOwner()).logMessage("Used " + data.numInstances() + " of '" + dataCont.getID() + "/" + data.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)classifier));
        TIntArrayList original = new TIntArrayList();
        for (i = 0; i < data.numInstances(); ++i) {
            original.add(i);
        }
        item.update(eval, this.m_Model, runInfo, original.toArray(), this.transferAdditionalAttributes(this.m_SelectAdditionalAttributes, data));
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClassifyTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.fillWithAttributeNames(this.m_SelectAdditionalAttributes, this.m_ComboBoxDatasets.getSelectedIndex());
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize() {
        Map<String, Object> result = super.serialize();
        result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        result.put(KEY_MODEL, ((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        result.put(KEY_ADDITIONAL, this.m_SelectAdditionalAttributes.getCurrent());
        result.put(KEY_DISCARDPREDICTIONS, this.m_CheckBoxDiscardPredictions.isSelected());
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex((Integer)data.get(KEY_DATASET));
        }
        if (data.containsKey(KEY_MODEL)) {
            this.m_PanelModel.setCurrent((File)new PlaceholderFile((String)data.get(KEY_MODEL)));
        }
        if (data.containsKey(KEY_ADDITIONAL)) {
            this.m_SelectAdditionalAttributes.setCurrent((Object)((String[])data.get(KEY_ADDITIONAL)));
        }
        if (data.containsKey(KEY_DISCARDPREDICTIONS)) {
            this.m_CheckBoxDiscardPredictions.setSelected((Boolean)data.get(KEY_DISCARDPREDICTIONS));
        }
    }
}

