/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.history;

import adams.core.logging.LoggingLevel;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.history.AbstractHistoryPopupMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class SubRangeEvaluation
extends AbstractHistoryPopupMenuItem {
    @Override
    public String getCategory() {
        return "Evaluation";
    }

    @Override
    public String getTitle() {
        return "Sub-range evaluation...";
    }

    protected double[] queryUser(ResultItem item) {
        Evaluation eval = item.getEvaluation();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Prediction pred : eval.predictions()) {
            min = Math.min(min, pred.actual());
            max = Math.max(max, pred.actual());
        }
        ParameterPanel params = new ParameterPanel();
        NumberTextField textMin = new NumberTextField(NumberTextField.Type.DOUBLE);
        textMin.setValue((Number)min);
        params.addParameter("Minimum", (Component)textMin);
        NumberTextField textMax = new NumberTextField(NumberTextField.Type.DOUBLE);
        textMax.setValue((Number)max);
        params.addParameter("Maximum", (Component)textMax);
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)this.m_Owner)) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)((Object)this.m_Owner)), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame((Container)((Object)this.m_Owner)), true);
        dialog.setTitle("Sub-range evaluation");
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this.m_Owner));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        min = textMin.getValue().doubleValue();
        if (min >= (max = textMax.getValue().doubleValue())) {
            GUIHelper.showErrorMessage((Component)((Object)this.m_Owner), (String)("Minimum must be smaller than maximum!\nmin: " + min + "\nmax: " + max));
            return null;
        }
        return new double[]{min, max};
    }

    protected MetaData addSubRangeInfo(MetaData info, double[] range) {
        MetaData result = info.getClone();
        String prefix = "Sub-range evaluation";
        int count = 0;
        boolean added = false;
        do {
            String key;
            if (!result.has(key = count == 0 ? prefix : prefix + " (" + (count + 1) + ")")) {
                result.add(key, (Object)("[" + range[0] + ";" + range[1] + "]"));
                added = true;
            }
            ++count;
        } while (!added);
        return result;
    }

    protected void createSubEvaluation(ClassifyTab.HistoryPanel history, ResultItem item, double[] range) {
        try {
            Evaluation evalFull = item.getEvaluation();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("Prediction"));
            Instances data = new Instances("[" + range[0] + ";" + range[1] + "]-" + evalFull.getHeader().relationName(), atts, evalFull.predictions().size());
            data.setClassIndex(0);
            for (Prediction pred : evalFull.predictions()) {
                DenseInstance inst = new DenseInstance(1.0, new double[]{pred.actual()});
                data.add((Instance)inst);
            }
            Evaluation evalSub = new Evaluation(data);
            for (int i = 0; i < evalFull.predictions().size(); ++i) {
                Prediction prd = (Prediction)evalFull.predictions().get(i);
                if (!(prd.actual() >= range[0]) || !(prd.actual() <= range[1])) continue;
                evalSub.evaluateModelOnceAndRecordPrediction(new double[]{prd.predicted()}, data.instance(i));
            }
            MetaData runInfoSub = this.addSubRangeInfo(item.getRunInformation(), range);
            ResultItem itemSub = new ResultItem(item.getTemplate(), new Instances(data, 0));
            itemSub.update(evalSub, null, runInfoSub);
            history.addEntry(itemSub.getName(), (Object)itemSub);
            history.setSelectedIndex(history.count() - 1);
            ((ClassifyTab)this.m_Owner).generateOutput(itemSub);
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)LoggingLevel.SEVERE, "Failed to generate sub-range evaluation!", (Throwable)e);
        }
    }

    @Override
    public JMenuItem createMenuItem(ClassifyTab.HistoryPanel history, int[] indices) {
        boolean enabled = indices.length == 1 && ((ResultItem)((Object)history.getEntry(indices[0]))).hasEvaluation() && ((ResultItem)((Object)history.getEntry(indices[0]))).getEvaluation().getHeader().classAttribute().isNumeric() && ((ResultItem)((Object)history.getEntry(indices[0]))).getEvaluation().predictions() != null;
        JMenuItem result = new JMenuItem(this.getTitle());
        result.setEnabled(enabled);
        if (!enabled) {
            return result;
        }
        ResultItem item = (ResultItem)((Object)history.getEntry(indices[0]));
        result.addActionListener(e -> {
            double[] range = this.queryUser(item);
            if (range == null) {
                return;
            }
            this.createSubEvaluation(history, item, range);
        });
        return result;
    }
}

