/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.AutoOnOff;
import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.ActualVsPredictedPlot;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.PredictionHelper;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ClassifierErrors
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    public static final int MAX_DATA_POINTS = 1000;
    protected ActualVsPredictedPlot.LimitType m_Limit;
    protected double m_ActualMin;
    protected double m_ActualMax;
    protected double m_PredictedMin;
    protected double m_PredictedMax;
    protected int m_Diameter;
    protected boolean m_UseError;
    protected AutoOnOff m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Generates classifier errors plot.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual-min", "actualMin", (Object)Double.NEGATIVE_INFINITY);
        this.m_OptionManager.add("actual-max", "actualMax", (Object)Double.POSITIVE_INFINITY);
        this.m_OptionManager.add("predicted-min", "predictedMin", (Object)Double.NEGATIVE_INFINITY);
        this.m_OptionManager.add("predicted-max", "predictedMax", (Object)Double.POSITIVE_INFINITY);
        this.m_OptionManager.add("limit", "limit", (Object)ActualVsPredictedPlot.LimitType.NONE);
        this.m_OptionManager.add("diameter", "diameter", (Object)7, (Number)1, null);
        this.m_OptionManager.add("use-error", "useError", (Object)false);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)AutoOnOff.AUTO);
    }

    public void setActualMin(double value) {
        this.m_ActualMin = value;
        this.reset();
    }

    public double getActualMin() {
        return this.m_ActualMin;
    }

    public String actualMinTipText() {
        return "The minimum to use for the display of the actual axis; use NaN for unlimited.";
    }

    public void setActualMax(double value) {
        this.m_ActualMax = value;
        this.reset();
    }

    public double getActualMax() {
        return this.m_ActualMax;
    }

    public String actualMaxTipText() {
        return "The maximum to use for the display of the actual axis; use NaN for unlimited.";
    }

    public void setPredictedMin(double value) {
        this.m_PredictedMin = value;
        this.reset();
    }

    public double getPredictedMin() {
        return this.m_PredictedMin;
    }

    public String predictedMinTipText() {
        return "The minimum to use for the display of the predicted axis; use NaN for unlimited.";
    }

    public void setPredictedMax(double value) {
        this.m_PredictedMax = value;
        this.reset();
    }

    public double getPredictedMax() {
        return this.m_PredictedMax;
    }

    public String predictedMaxTipText() {
        return "The maximum to use for the display of the predicted axis; use NaN for unlimited.";
    }

    public void setLimit(ActualVsPredictedPlot.LimitType value) {
        this.m_Limit = value;
        this.reset();
    }

    public ActualVsPredictedPlot.LimitType getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The type of limit to impose on the axes; NONE just uses the range determined from the data; ACTUAL uses the min/max from the actual column for both axes; SPECIFIED uses the specified limits or, if a value is 'infinity' then the corresponding value from the determine range.";
    }

    public void setDiameter(int value) {
        if (this.getOptionManager().isValid("diameter", (Number)value)) {
            this.m_Diameter = value;
            this.reset();
        }
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the cross in pixels (if no error data supplied).";
    }

    public void setUseError(boolean value) {
        this.m_UseError = value;
        this.reset();
    }

    public boolean getUseError() {
        return this.m_UseError;
    }

    public String useErrorTipText() {
        return "If enabled, the numeric error is used for the cross size.";
    }

    @Override
    public String getTitle() {
        return "Errors";
    }

    public void setAntiAliasingEnabled(AutoOnOff value) {
        this.m_AntiAliasingEnabled = value;
        this.reset();
    }

    public AutoOnOff isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "In auto mode, anti-aliasing is turned off if more than 1000 present or the system wide setting has been turned off.";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null;
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        boolean showError = this.m_UseError && item.getEvaluation().getHeader().classAttribute().isNumeric();
        SpreadSheet sheet = PredictionHelper.toSpreadSheet((LoggingSupporter)this, errors, item, true, showError);
        if (sheet == null) {
            if (errors.isEmpty()) {
                errors.add("Failed to generate prediction!");
            }
            return null;
        }
        Token token = new Token((Object)sheet);
        ActualVsPredictedPlot sink = new ActualVsPredictedPlot();
        sink.setActualMin(this.m_ActualMin);
        sink.setActualMax(this.m_ActualMax);
        sink.setPredictedMin(this.m_PredictedMin);
        sink.setPredictedMax(this.m_PredictedMax);
        sink.setLimit(this.m_Limit);
        sink.setDiameter(this.m_Diameter);
        sink.setShowSidePanel(false);
        switch (this.m_AntiAliasingEnabled) {
            case AUTO: {
                sink.setAntiAliasingEnabled(((SpreadSheet)token.getPayload()).getRowCount() <= 1000 && GUIHelper.AntiAliasingEnabled);
                break;
            }
            case ON: {
                sink.setAntiAliasingEnabled(true);
                break;
            }
            case OFF: {
                sink.setAntiAliasingEnabled(false);
            }
        }
        if (showError) {
            sink.setError(new SpreadSheetColumnIndex("Error"));
        }
        ArrayList<String> additional = null;
        if (item.hasAdditionalAttributes()) {
            additional = new ArrayList<String>();
            for (int i = 0; i < item.getAdditionalAttributes().getColumnCount(); ++i) {
                additional.add(SpreadSheetColumnRange.escapeName((String)item.getAdditionalAttributes().getColumnName(i)));
            }
        }
        if (additional != null && additional.size() > 0) {
            sink.setAdditional(new SpreadSheetColumnRange(Utils.flatten(additional, (String)",")));
        }
        AbstractDisplayPanel panel = sink.createDisplayPanel(token);
        return new ComponentContentPanel((JComponent)panel, sink.displayPanelRequiresScrollPane());
    }
}

