/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.data.weka.WekaLabelIndex;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.WekaCostBenefitAnalysis;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import javax.swing.JComponent;

public class LegacyCostBenefitAnalysis
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected WekaLabelIndex m_ClassIndex;

    public String globalInfo() {
        return "Generates cost benefit analysis (legacy Weka output).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classIndex", (Object)new WekaLabelIndex("first"));
    }

    public void setClassIndex(WekaLabelIndex value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public WekaLabelIndex getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The range of class label indices.";
    }

    @Override
    public String getTitle() {
        return "Cost benefit (legacy)";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null && item.getEvaluation().getHeader().classAttribute().isNominal();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        WekaCostBenefitAnalysis sink = new WekaCostBenefitAnalysis();
        sink.setClassIndex(this.m_ClassIndex);
        AbstractDisplayPanel panel = sink.createDisplayPanel(new Token((Object)item.getEvaluation()));
        panel.setPreferredSize(GUIHelper.getDefaultDialogDimension());
        return new ComponentContentPanel((JComponent)panel, sink.displayPanelRequiresScrollPane());
    }
}

