/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.data.weka.WekaLabelRange;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.WekaThresholdCurve;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import javax.swing.JComponent;

public class LegacyThresholdCurve
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected WekaLabelRange m_ClassLabelRange;
    protected WekaThresholdCurve.AttributeName m_AttributeX;
    protected WekaThresholdCurve.AttributeName m_AttributeY;

    public String globalInfo() {
        return "Generates margin curve (legacy Weka output).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classLabelRange", (Object)new WekaLabelRange("first"));
        this.m_OptionManager.add("attribute-x", "attributeX", (Object)WekaThresholdCurve.AttributeName.FP_RATE);
        this.m_OptionManager.add("attribute-y", "attributeY", (Object)WekaThresholdCurve.AttributeName.TP_RATE);
    }

    public void setClassLabelRange(WekaLabelRange value) {
        this.m_ClassLabelRange = value;
        this.reset();
    }

    public WekaLabelRange getClassLabelRange() {
        return this.m_ClassLabelRange;
    }

    public String classLabelRangeTipText() {
        return "The indices of the class labels to use for the plot.";
    }

    public void setAttributeX(WekaThresholdCurve.AttributeName value) {
        this.m_AttributeX = value;
        this.reset();
    }

    public WekaThresholdCurve.AttributeName getAttributeX() {
        return this.m_AttributeX;
    }

    public String attributeXTipText() {
        return "The attribute to show on the X axis.";
    }

    public void setAttributeY(WekaThresholdCurve.AttributeName value) {
        this.m_AttributeY = value;
        this.reset();
    }

    public WekaThresholdCurve.AttributeName getAttributeY() {
        return this.m_AttributeY;
    }

    public String attributeYTipText() {
        return "The attribute to show on the Y axis.";
    }

    @Override
    public String getTitle() {
        return "Threshold curve (legacy)";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null && item.getEvaluation().getHeader().classAttribute().isNominal();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        WekaThresholdCurve sink = new WekaThresholdCurve();
        sink.setClassLabelRange(this.m_ClassLabelRange);
        sink.setAttributeX(this.m_AttributeX);
        sink.setAttributeY(this.m_AttributeY);
        AbstractDisplayPanel panel = sink.createDisplayPanel(new Token((Object)item.getEvaluation()));
        return new ComponentContentPanel((JComponent)panel, sink.displayPanelRequiresScrollPane());
    }
}

