/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.RunInformationHelper;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class TextStatistics
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected boolean m_ConfusionMatrix;
    protected boolean m_ComplexityStatistics;
    protected boolean m_ClassDetails;
    protected boolean m_RunInformation;

    public String globalInfo() {
        return "Generates basic text statistic.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("confusion-matrix", "confusionMatrix", (Object)false);
        this.m_OptionManager.add("complexity-stats", "complexityStatistics", (Object)false);
        this.m_OptionManager.add("class-details", "classDetails", (Object)false);
        this.m_OptionManager.add("run-information", "runInformation", (Object)false);
    }

    public void setConfusionMatrix(boolean value) {
        this.m_ConfusionMatrix = value;
        this.reset();
    }

    public boolean getConfusionMatrix() {
        return this.m_ConfusionMatrix;
    }

    public String confusionMatrixTipText() {
        return "If set to true, then the confusion matrix will be output as well.";
    }

    public void setComplexityStatistics(boolean value) {
        this.m_ComplexityStatistics = value;
        this.reset();
    }

    public boolean getComplexityStatistics() {
        return this.m_ComplexityStatistics;
    }

    public String complexityStatisticsTipText() {
        return "If set to true, then the complexity statistics will be output as well.";
    }

    public void setClassDetails(boolean value) {
        this.m_ClassDetails = value;
        this.reset();
    }

    public boolean getClassDetails() {
        return this.m_ClassDetails;
    }

    public String classDetailsTipText() {
        return "If set to true, then the class details are output as well.";
    }

    public void setRunInformation(boolean value) {
        this.m_RunInformation = value;
        this.reset();
    }

    public boolean getRunInformation() {
        return this.m_RunInformation;
    }

    public String runInformationTipText() {
        return "If set to true, then the run information is output as well.";
    }

    @Override
    public String getTitle() {
        return "Statistics";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(item.getEvaluation().toSummaryString(this.m_ComplexityStatistics));
        }
        catch (Exception e) {
            buffer.append(item.getEvaluation().toSummaryString(false));
            Utils.handleException((LoggingSupporter)this, (String)"Failed to generate summary statistics: ", (Throwable)e);
        }
        if (this.m_ConfusionMatrix) {
            try {
                buffer.append("\n\n" + item.getEvaluation().toMatrixString());
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)this, (String)"Failed to generate confusion matrix: ", (Throwable)e);
            }
        }
        if (this.m_ClassDetails) {
            try {
                buffer.append("\n\n" + item.getEvaluation().toClassDetailsString());
            }
            catch (Exception e) {
                Utils.handleException((LoggingSupporter)this, (String)"Failed to generate class details: ", (Throwable)e);
            }
        }
        if (this.m_RunInformation && item.hasRunInformation()) {
            buffer.append("\n\n=== Run information ===\n\n");
            buffer.append(RunInformationHelper.toString(item.getRunInformation().toSpreadSheet()));
        }
        BaseTextArea text = new BaseTextArea();
        text.setEditable(false);
        text.setTextFont(Fonts.getMonospacedFont());
        text.setText(buffer.toString());
        text.setCaretPosition(0);
        return new TextualContentPanel((JTextComponent)text, true);
    }
}

