/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.evaluation;

import adams.core.MessageCollection;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.ClusterTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Capabilities;
import weka.core.Instances;

public class TrainTestSet
extends AbstractClustererEvaluation {
    private static final long serialVersionUID = -4460266467650893551L;
    protected ParameterPanel m_PanelParameters;
    protected JComboBox<String> m_ComboBoxTrain;
    protected JComboBox<String> m_ComboBoxTest;
    protected DefaultComboBoxModel<String> m_ModelDatasets;

    public String globalInfo() {
        return "Builds the clusterer on the selected training set and evaluates it against the selected test set.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxTrain = new JComboBox<String>(this.m_ModelDatasets);
        this.m_ComboBoxTrain.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Train", this.m_ComboBoxTrain);
        this.m_ComboBoxTest = new JComboBox<String>(this.m_ModelDatasets);
        this.m_ComboBoxTest.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Test", this.m_ComboBoxTest);
    }

    @Override
    public String getName() {
        return "Train/test set";
    }

    @Override
    public String canEvaluate(Clusterer clusterer) {
        if (!this.isValidDataIndex(this.m_ComboBoxTrain)) {
            return "No train data available!";
        }
        if (!this.isValidDataIndex(this.m_ComboBoxTest)) {
            return "No test data available!";
        }
        Capabilities caps = clusterer.getCapabilities();
        Instances train = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex()).getData();
        try {
            if (!caps.test(train)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Clusterer cannot handle tain data!";
            }
        }
        catch (Exception e) {
            return "Clusterer cannot handle data: " + e;
        }
        caps = clusterer.getCapabilities();
        Instances test = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex()).getData();
        try {
            if (!caps.test(test)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Clusterer cannot handle test data!";
            }
        }
        catch (Exception e) {
            return "Clusterer cannot handle data: " + e;
        }
        if (!train.equalHeaders(test)) {
            return train.equalHeadersMsg(test);
        }
        return null;
    }

    @Override
    public ResultItem init(Clusterer clusterer) throws Exception {
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(clusterer, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Clusterer clusterer, ResultItem item) throws Exception {
        String msg = this.canEvaluate(clusterer);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate clusterer!\n" + msg);
        }
        DataContainer trainCont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex());
        Instances train = trainCont.getData();
        DataContainer testCont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex());
        Instances test = testCont.getData();
        MetaData runInfo = new MetaData();
        runInfo.add("Clusterer", (Object)OptionUtils.getCommandLine((Object)clusterer));
        runInfo.add("Train ID", (Object)trainCont.getID());
        runInfo.add("Test ID", (Object)testCont.getID());
        runInfo.add("Relation", (Object)train.relationName());
        runInfo.add("# Attributes", (Object)train.numAttributes());
        runInfo.add("# Instances (train)", (Object)train.numInstances());
        runInfo.add("# Instances (test)", (Object)test.numInstances());
        Clusterer model = (Clusterer)OptionUtils.shallowCopy((Object)clusterer);
        ((ClusterTab)this.getOwner()).logMessage("Using '" + train.relationName() + "' to train " + OptionUtils.getCommandLine((Object)clusterer));
        model.buildClusterer(train);
        this.addObjectSize(runInfo, "Model size", model);
        ((ClusterTab)this.getOwner()).logMessage("Using '" + test.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)clusterer));
        ClusterEvaluation eval = new ClusterEvaluation();
        eval.setClusterer(model);
        eval.evaluateClusterer(test);
        item.update(eval, model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClusterTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClusterTab)this.getOwner()).getData());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            int index = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxTrain.getSelectedItem());
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxTrain.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxTrain.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxTrain.setSelectedIndex(index);
            }
            index = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxTest.getSelectedItem());
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxTest.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxTest.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxTest.setSelectedIndex(index);
            }
        }
        ((ClusterTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxTrain.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize() {
        Map<String, Object> result = super.serialize();
        result.put("train", this.m_ComboBoxTrain.getSelectedIndex());
        result.put("test", this.m_ComboBoxTest.getSelectedIndex());
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey("train")) {
            this.m_ComboBoxTrain.setSelectedIndex((Integer)data.get("train"));
        }
        if (data.containsKey("test")) {
            this.m_ComboBoxTest.setSelectedIndex((Integer)data.get("test"));
        }
    }
}

