/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab;

import adams.gui.core.BaseTable;
import adams.gui.core.GUIHelper;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.Instances;

public class AttributeSelectionPanel
extends JPanel
implements TableModelListener,
ListSelectionListener {
    private static final long serialVersionUID = 627131485290359194L;
    protected JButton m_ButtonAll = new JButton("All");
    protected JButton m_ButtonNone = new JButton("None");
    protected JButton m_ButtonInvert = new JButton("Invert");
    protected JButton m_ButtonPattern = new JButton("Pattern");
    protected BaseTable m_Table = new BaseTable();
    protected AttributeTableModel m_Model;
    protected String m_PatternRegEx = "";
    protected Set<ChangeListener> m_ChangeListeners = new HashSet<ChangeListener>();
    protected Set<ListSelectionListener> m_SelectionListeners = new HashSet<ListSelectionListener>();

    public AttributeSelectionPanel() {
        this(true, true, true, true);
    }

    public AttributeSelectionPanel(boolean include, boolean remove, boolean invert, boolean pattern) {
        this.m_ButtonAll.setToolTipText("Selects all attributes");
        this.m_ButtonAll.setEnabled(false);
        this.m_ButtonAll.addActionListener(e -> this.m_Model.selectAll());
        this.m_ButtonNone.setToolTipText("Unselects all attributes");
        this.m_ButtonNone.setEnabled(false);
        this.m_ButtonNone.addActionListener(e -> this.m_Model.selectNone());
        this.m_ButtonInvert.setToolTipText("Inverts the current attribute selection");
        this.m_ButtonInvert.setEnabled(false);
        this.m_ButtonInvert.addActionListener(e -> this.m_Model.invert());
        this.m_ButtonPattern.setToolTipText("Selects all attributes that match a reg. expression");
        this.m_ButtonPattern.setEnabled(false);
        this.m_ButtonPattern.addActionListener(e -> {
            String patternStr = GUIHelper.showInputDialog((Component)this.m_ButtonPattern.getParent(), (String)"Enter a Perl regular expression", (String)this.m_PatternRegEx);
            if (patternStr != null) {
                try {
                    Pattern.compile(patternStr);
                    this.m_PatternRegEx = patternStr;
                    this.m_Model.pattern(patternStr);
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage((Component)this.m_ButtonPattern.getParent(), (String)("'" + patternStr + "' is not a valid Perl regular expression!"), (Throwable)ex, (String)"Error in Pattern...");
                }
            }
        });
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new GridLayout(1, 4, 5, 5));
        if (include) {
            p1.add(this.m_ButtonAll);
        }
        if (remove) {
            p1.add(this.m_ButtonNone);
        }
        if (invert) {
            p1.add(this.m_ButtonInvert);
        }
        if (pattern) {
            p1.add(this.m_ButtonPattern);
        }
        this.setLayout(new BorderLayout());
        if (include || remove || invert || pattern) {
            this.add((Component)p1, "North");
        }
        this.add((Component)new JScrollPane((Component)this.m_Table), "Center");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.m_Table.getPreferredScrollableViewportSize();
    }

    public void setPreferredScrollableViewportSize(Dimension d) {
        this.m_Table.setPreferredScrollableViewportSize(d);
    }

    public void setInstances(Instances newInstances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(newInstances);
            this.m_Model.addTableModelListener(this);
            this.m_Table.setModel((TableModel)this.m_Model);
            TableColumnModel tcm = this.m_Table.getColumnModel();
            tcm.getColumn(0).setMaxWidth(60);
            tcm.getColumn(1).setMaxWidth(tcm.getColumn(1).getMinWidth());
            tcm.getColumn(2).setMinWidth(100);
        } else {
            this.m_Model.setInstances(newInstances);
            this.m_Table.clearSelection();
        }
        this.m_ButtonAll.setEnabled(true);
        this.m_ButtonNone.setEnabled(true);
        this.m_ButtonInvert.setEnabled(true);
        this.m_ButtonPattern.setEnabled(true);
        this.m_Table.sizeColumnsToFit(2);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public int[] getSelectedRows() {
        return this.m_Table.getSelectedRows();
    }

    public int[] getSelectedAttributes() {
        return this.m_Model == null ? null : this.m_Model.getSelectedAttributes();
    }

    public void setSelectedAttributes(boolean[] selected) throws Exception {
        if (this.m_Model != null) {
            this.m_Model.setSelectedAttributes(selected);
        }
    }

    public BaseTable getTable() {
        return this.m_Table;
    }

    public TableModel getTableModel() {
        return this.m_Model;
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.notifyChangeListeners();
    }

    public void addSelectionListener(ListSelectionListener l) {
        this.m_SelectionListeners.add(l);
    }

    public void removeSelectionListener(ListSelectionListener l) {
        this.m_SelectionListeners.remove(l);
    }

    protected void notifySelectionListeners(ListSelectionEvent e) {
        for (ListSelectionListener l : this.m_SelectionListeners) {
            l.valueChanged(e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.notifySelectionListeners(e);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            weka.gui.AttributeSelectionPanel asp = new weka.gui.AttributeSelectionPanel();
            final JFrame jf = new JFrame("Attribute Selection Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)asp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            asp.setInstances(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4152987434024338064L;
        protected Instances m_Instances;
        protected HashMap<String, Boolean> m_Selected;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
            this.m_Selected = new HashMap();
        }

        @Override
        public int getRowCount() {
            if (this.m_Instances == null) {
                return 0;
            }
            return this.m_Instances.numAttributes();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.m_Instances.numAttributes()) {
                return null;
            }
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.m_Selected.containsKey(this.m_Instances.attribute(row).name()) && this.m_Selected.get(this.m_Instances.attribute(row).name()) != false;
                }
                case 2: {
                    return this.m_Instances.attribute(row).name();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "No.";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "Name";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.m_Selected.put(this.m_Instances.attribute(row).name(), (Boolean)value);
                this.fireTableRowsUpdated(0, this.getRowCount());
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int[] getSelectedAttributes() {
            TIntArrayList result = new TIntArrayList();
            if (this.m_Instances != null) {
                for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                    String name = this.m_Instances.attribute(i).name();
                    if (!this.m_Selected.containsKey(name) || !this.m_Selected.get(name).booleanValue()) continue;
                    result.add(i);
                }
            }
            return result.toArray();
        }

        public void selectAll() {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                this.m_Selected.put(this.m_Instances.attribute(i).name(), true);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void selectNone() {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                this.m_Selected.put(this.m_Instances.attribute(i).name(), false);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void invert() {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                String name = this.m_Instances.attribute(i).name();
                boolean current = this.m_Selected.containsKey(name) && this.m_Selected.get(name) != false;
                this.m_Selected.put(name, !current);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void pattern(String pattern) {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                String name = this.m_Instances.attribute(i).name();
                this.m_Selected.put(name, Pattern.matches(pattern, name));
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void setSelectedAttributes(boolean[] selected) throws Exception {
            if (this.m_Instances == null) {
                return;
            }
            if (selected.length != this.getRowCount()) {
                throw new Exception("Supplied array does not have the same number of elements as there are attributes!");
            }
            for (int i = 0; i < selected.length; ++i) {
                this.m_Selected.put(this.m_Instances.attribute(i).name(), selected[i]);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }
}

