/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction;

import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.AbstractSelectedAttributesAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class RemoveChecked
extends AbstractSelectedAttributesAction {
    private static final long serialVersionUID = -217537095007987947L;

    public RemoveChecked() {
        this.setName("Remove checked");
        this.setIcon("delete.gif");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        if (this.getSelectedRows().length != 1) {
            return;
        }
        int index = this.getSelectedRows()[0];
        DataContainer cont = this.getData().get(index);
        int[] indices = this.getOwner().getAttributeSelectionPanel().getSelectedAttributes();
        if (indices.length == 0) {
            return;
        }
        Runnable run = () -> {
            this.showStatus("Removing checked attributes...");
            boolean keep = this.getOwner().getCheckBoxKeepName().isSelected();
            String oldName = cont.getData().relationName();
            Remove remove = new Remove();
            remove.setAttributeIndicesArray(indices);
            try {
                remove.setInputFormat(cont.getData());
                Instances filtered = Filter.useFilter((Instances)cont.getData(), (Filter)remove);
                if (keep) {
                    filtered.setRelationName(oldName);
                }
                cont.setData(filtered);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getSelectedRows()[0]));
                SwingUtilities.invokeLater(() -> {
                    if (this.getOwner().getAttributeSelectionPanel().getTable().getRowCount() > 0) {
                        this.getOwner().getAttributeSelectionPanel().getTable().setSelectedRow(0);
                    }
                });
            }
            catch (Throwable ex) {
                GUIHelper.showErrorMessage((Component)((Object)this.m_Owner), (String)"Failed to remove checked attributes!", (Throwable)ex);
            }
            this.m_Owner.executionFinished();
            this.showStatus("");
        };
        this.m_Owner.submitJob(run);
    }

    @Override
    public void update() {
        this.setEnabled(this.getOwner() != null && !this.isBusy() && this.getSelectedRows().length == 1 && this.getOwner().getAttributeSelectionPanel().getSelectedAttributes().length > 0 && this.m_Owner.canStartExecution());
    }
}

