/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter;

import adams.core.Utils;
import adams.env.Environment;
import adams.gui.core.BaseFrame;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekamultiexperimenter.ExperimenterEntryPanel;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.workspace.AbstractWorkspaceManagerPanel;
import adams.gui.workspace.AbstractWorkspacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.SwingUtilities;
import weka.core.Memory;
import weka.core.logging.Logger;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;

public class MultiExperimenter
extends AbstractWorkspaceManagerPanel<ExperimenterPanel> {
    private static final long serialVersionUID = -20320489406680254L;
    private static MultiExperimenter m_Experimenter;
    protected static Memory m_Memory;

    protected String getDefaultWorkspaceName() {
        return "Session";
    }

    protected ExperimenterPanel newWorkspace(boolean init) {
        return new ExperimenterPanel();
    }

    protected ExperimenterEntryPanel newWorkspaceList() {
        return new ExperimenterEntryPanel();
    }

    public void load(File file) {
        this.load(new File[]{file});
    }

    public void load(File[] files) {
        for (File file : files) {
            String name = file.getName();
            if (name.lastIndexOf(46) > -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            ExperimenterPanel panel = new ExperimenterPanel();
            this.addPanel((AbstractWorkspacePanel)panel, name);
            SwingUtilities.invokeLater(() -> panel.openSetup(file));
        }
    }

    public static void runExperimenter(String[] args) {
        String env;
        try {
            env = weka.core.Utils.getOption((String)"env", (String[])args);
        }
        catch (Exception e) {
            env = "";
        }
        if (env.isEmpty()) {
            env = Environment.class.getName();
        }
        try {
            Environment.setEnvironmentClass(Class.forName(env));
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate environment class: " + env);
            e.printStackTrace();
            Environment.setEnvironmentClass(Environment.class);
        }
        Logger.log((Logger.Level)Logger.Level.INFO, (String)"Logging started");
        LookAndFeel.setLookAndFeel();
        GenericObjectEditor.determineClasses();
        try {
            m_Experimenter = new MultiExperimenter();
            final BaseFrame frame = new BaseFrame("Multi-Experimenter");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)((Object)m_Experimenter), "Center");
            frame.pack();
            frame.setSize(GUIHelper.getDefaultLargeDialogDimension());
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        frame.dispose();
                        m_Experimenter = null;
                        System.gc();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            Logger.log((Logger.Level)Logger.Level.SEVERE, (String)Utils.throwableToString((Throwable)ex));
            System.err.println("An Exception occurred: ");
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MultiExperimenter.runExperimenter(args);
    }

    static {
        m_Memory = new Memory(true);
    }
}

