/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.analysis;

import adams.core.ClassLister;
import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Properties;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.CheckedTextField;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.analysis.AbstractAnalysisPanel;
import adams.gui.tools.wekamultiexperimenter.analysis.AbstractResultsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.Tester;

public class DefaultAnalysisPanel
extends AbstractAnalysisPanel {
    private static final long serialVersionUID = 7850777725811230009L;
    public static final String PERCENT_CORRECT = "Percent_correct";
    public static final String CORRELATION_COEFFICIENT = "Correlation_coefficient";
    public static final String KEY_RUN = "Key_Run";
    public static final String KEY_FOLD = "Key_Fold";
    public static final String KEY_DATASET = "Key_Dataset";
    public static final String KEY_SCHEME = "Key_Scheme";
    public static final String KEY_SCHEME_OPTIONS = "Key_Scheme_options";
    public static final String KEY_SCHEME_VERSION_ID = "Key_Scheme_version_ID";
    protected GenericObjectEditorPanel m_PanelTester;
    protected GenericObjectEditorPanel m_PanelMatrix;
    protected NumberTextField m_TextSignificance;
    protected SelectOptionPanel m_SelectRows;
    protected SelectOptionPanel m_SelectColumns;
    protected JCheckBox m_CheckBoxSwapRowsColumns;
    protected SelectOptionPanel m_SelectComparisonBase;
    protected JComboBox<String> m_ComboBoxMetric;
    protected DefaultComboBoxModel<String> m_ModelMetric;
    protected JComboBox<AbstractResultsPanel> m_ComboBoxResults;
    protected List<AbstractResultsPanel> m_PanelsResults;
    protected JButton m_ButtonAnalyze;
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected HistoryPanel m_History;
    protected DateFormat m_Formatter;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelMetric = new DefaultComboBoxModel();
        this.m_PanelsResults = new ArrayList<AbstractResultsPanel>();
        for (Class cls : ClassLister.getSingleton().getClasses(AbstractResultsPanel.class)) {
            try {
                AbstractResultsPanel panel = (AbstractResultsPanel)((Object)cls.newInstance());
                this.m_PanelsResults.add(panel);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate results panel: " + cls.getName(), (Throwable)e);
            }
        }
        this.m_Formatter = DateUtils.getTimeFormatter();
    }

    protected void initGUI() {
        ResultMatrix matrix;
        Tester tester;
        super.initGUI();
        Properties props = ExperimenterPanel.getProperties();
        this.setLayout(new BorderLayout());
        JPanel panelTop = new JPanel(new FlowLayout(0));
        this.add(panelTop, "North");
        ParameterPanel panelParams = new ParameterPanel();
        panelTop.add((Component)panelParams, "Center");
        try {
            tester = (Tester)Class.forName(props.getProperty("Results.Tester", PairedCorrectedTTester.class.getName())).newInstance();
        }
        catch (Exception e2) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate tester: " + props.getProperty("Results.Tester"), (Throwable)e2);
            tester = new PairedCorrectedTTester();
        }
        this.m_PanelTester = new GenericObjectEditorPanel(Tester.class, (Object)tester, true);
        panelParams.addParameter("Tester", (Component)this.m_PanelTester);
        try {
            matrix = (ResultMatrix)Class.forName(props.getProperty("Results.ResultMatrix", ResultMatrixPlainText.class.getName())).newInstance();
        }
        catch (Exception e3) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate matrix: " + props.getProperty("Results.ResultMatrix"), (Throwable)e3);
            matrix = new ResultMatrixPlainText();
        }
        this.m_PanelMatrix = new GenericObjectEditorPanel(ResultMatrix.class, (Object)matrix, true);
        panelParams.addParameter("Output", (Component)this.m_PanelMatrix);
        double siglevel = props.getDouble("Results.SignificanceLevel", Double.valueOf(0.05));
        this.m_TextSignificance = new NumberTextField(NumberTextField.Type.DOUBLE);
        this.m_TextSignificance.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)0.0, (Number)1.0, (Number)siglevel));
        this.m_TextSignificance.setValue((Number)siglevel);
        panelParams.addParameter("Significance level", (Component)this.m_TextSignificance);
        this.m_SelectRows = new SelectOptionPanel();
        this.m_SelectRows.setCurrent((Object)new String[]{KEY_DATASET});
        this.m_SelectRows.setMultiSelect(true);
        this.m_SelectRows.setLenient(true);
        this.m_SelectRows.setDialogTitle("Select row identifiers");
        this.m_SelectRows.addChangeListener(e -> this.updateComparisonBase());
        panelParams.addParameter("Rows", (Component)this.m_SelectRows);
        this.m_SelectColumns = new SelectOptionPanel();
        this.m_SelectColumns.setCurrent((Object)new String[]{KEY_SCHEME, KEY_SCHEME_OPTIONS, KEY_SCHEME_VERSION_ID});
        this.m_SelectColumns.setMultiSelect(true);
        this.m_SelectColumns.setLenient(true);
        this.m_SelectColumns.setDialogTitle("Select column identifiers");
        this.m_SelectColumns.addChangeListener(e -> this.updateComparisonBase());
        panelParams.addParameter("Columns", (Component)this.m_SelectColumns);
        this.m_CheckBoxSwapRowsColumns = new JCheckBox();
        this.m_CheckBoxSwapRowsColumns.addActionListener(e -> this.updateComparisonBase());
        panelParams.addParameter("Swap rows/columns", (Component)this.m_CheckBoxSwapRowsColumns);
        this.m_SelectComparisonBase = new SelectOptionPanel();
        this.m_SelectComparisonBase.setCurrent((Object)new String[0]);
        this.m_SelectComparisonBase.setMultiSelect(false);
        this.m_SelectComparisonBase.setLenient(true);
        this.m_SelectComparisonBase.setDialogTitle("Select the base to compare against");
        this.m_SelectComparisonBase.addChangeListener(e -> this.updateButtons());
        panelParams.addParameter("Comparison base", (Component)this.m_SelectComparisonBase);
        this.m_ComboBoxMetric = new JComboBox<String>(this.m_ModelMetric);
        panelParams.addParameter("Metric", this.m_ComboBoxMetric);
        this.m_ComboBoxResults = new JComboBox<AbstractResultsPanel>(new DefaultComboBoxModel<AbstractResultsPanel>(this.m_PanelsResults.toArray(new AbstractResultsPanel[this.m_PanelsResults.size()])));
        panelParams.addParameter("Results", this.m_ComboBoxResults);
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setDividerLocation(200);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        this.m_PanelLeft.add((Component)panelButtons, "North");
        this.m_ButtonAnalyze = new JButton("Analyze");
        this.m_ButtonAnalyze.addActionListener(e -> this.analyze());
        panelButtons.add(this.m_ButtonAnalyze);
        this.m_History = new HistoryPanel(this);
        this.m_PanelLeft.add((Component)((Object)this.m_History));
    }

    @Override
    public String getAnalysisName() {
        return "Default";
    }

    public JPanel getPanelRight() {
        return this.m_PanelRight;
    }

    public void setResultMatrix(ResultMatrix value) {
        this.m_PanelMatrix.setCurrent((Object)value);
    }

    public ResultMatrix getResultMatrix() {
        return (ResultMatrix)this.m_PanelMatrix.getCurrent();
    }

    public void setTester(Tester value) {
        this.m_PanelTester.setCurrent((Object)value);
    }

    public Tester getTester() {
        return (Tester)this.m_PanelTester.getCurrent();
    }

    @Override
    public String handlesResults(Instances results) {
        return null;
    }

    @Override
    public DefaultAnalysisPanel getClone() {
        DefaultAnalysisPanel result = new DefaultAnalysisPanel();
        result.setResultMatrix(this.getResultMatrix());
        result.setTester(this.getTester());
        return result;
    }

    @Override
    protected void update() {
        int index;
        String oldValue = (String)this.m_ComboBoxMetric.getSelectedItem();
        DefaultComboBoxModel<String> metric = new DefaultComboBoxModel<String>();
        if (this.m_Results != null) {
            for (index = 0; index < this.m_Results.numAttributes(); ++index) {
                metric.addElement(this.m_Results.attribute(index).name());
            }
        }
        this.m_ModelMetric = metric;
        this.m_ComboBoxMetric.setModel(this.m_ModelMetric);
        index = -1;
        if (oldValue != null) {
            index = this.m_ModelMetric.getIndexOf(oldValue);
        }
        if (index == -1) {
            index = this.m_ModelMetric.getIndexOf(PERCENT_CORRECT);
        }
        if (index == -1) {
            index = this.m_ModelMetric.getIndexOf(CORRELATION_COEFFICIENT);
        }
        if (index > -1) {
            this.m_ComboBoxMetric.setSelectedIndex(index);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.m_Results != null) {
            for (index = 0; index < this.m_Results.numAttributes(); ++index) {
                names.add(this.m_Results.attribute(index).name());
            }
        }
        this.m_SelectRows.setOptions(names.toArray(new String[names.size()]));
        this.m_SelectColumns.setOptions(names.toArray(new String[names.size()]));
        this.updateComparisonBase();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonAnalyze.setEnabled(this.m_Results != null && this.m_SelectComparisonBase.getCurrentIndex() > -1);
    }

    protected int getAttributeIndex(String attName) {
        if (this.m_Results == null) {
            return -1;
        }
        Attribute att = this.m_Results.attribute(attName);
        if (att == null) {
            return -1;
        }
        return att.index();
    }

    protected String getRange(SelectOptionPanel select) {
        int[] options;
        StringBuilder result = new StringBuilder();
        for (int option : options = select.getCurrentIndices()) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("" + (option + 1));
        }
        return result.toString();
    }

    protected void updateComparisonBase() {
        if (this.m_Results == null) {
            this.m_SelectComparisonBase.setOptions(new String[0]);
            return;
        }
        boolean swapped = this.m_CheckBoxSwapRowsColumns.isSelected();
        int[] atts = swapped ? this.m_SelectRows.getCurrentIndices() : this.m_SelectColumns.getCurrentIndices();
        HashSet<String> unique = new HashSet<String>();
        ArrayList<String> options = new ArrayList<String>();
        for (int i = 0; i < this.m_Results.numInstances(); ++i) {
            Instance inst = this.m_Results.instance(i);
            StringBuilder combined = new StringBuilder();
            block4: for (int n = 0; n < atts.length; ++n) {
                if (n > 0) {
                    combined.append(" ");
                }
                if (inst.isMissing(atts[n])) {
                    combined.append("?");
                    continue;
                }
                switch (this.m_Results.attribute(atts[n]).type()) {
                    case 0: {
                        combined.append("" + inst.value(atts[n]));
                        continue block4;
                    }
                    default: {
                        combined.append(inst.stringValue(atts[n]));
                    }
                }
            }
            String key = combined.toString();
            if (unique.contains(key)) continue;
            options.add(key);
            unique.add(key);
        }
        this.m_SelectComparisonBase.setOptions(options.toArray(new String[options.size()]));
        if (this.m_SelectComparisonBase.getCurrentIndex() == -1) {
            this.m_SelectComparisonBase.setCurrentIndex(0);
        }
    }

    protected void analyze() {
        if (this.m_Results == null) {
            return;
        }
        ResultMatrix matrix = this.getResultMatrix();
        Tester tester = this.getTester();
        tester.setInstances(this.m_Results);
        tester.setSortColumn(-1);
        tester.setRunColumn(this.getAttributeIndex(KEY_RUN));
        tester.setFoldColumn(this.getAttributeIndex(KEY_FOLD));
        if (this.m_CheckBoxSwapRowsColumns.isSelected()) {
            tester.setDatasetKeyColumns(new Range(this.getRange(this.m_SelectColumns)));
            tester.setResultsetKeyColumns(new Range(this.getRange(this.m_SelectRows)));
        } else {
            tester.setDatasetKeyColumns(new Range(this.getRange(this.m_SelectRows)));
            tester.setResultsetKeyColumns(new Range(this.getRange(this.m_SelectColumns)));
        }
        tester.setResultMatrix(matrix);
        tester.setDisplayedResultsets(null);
        tester.setSignificanceLevel(this.m_TextSignificance.getValue((Number)0.05).doubleValue());
        tester.setShowStdDevs(matrix.getShowStdDev());
        String metric = "" + this.m_ComboBoxMetric.getSelectedItem();
        int index = this.getAttributeIndex(metric);
        if (index == -1) {
            index = this.getAttributeIndex(PERCENT_CORRECT);
        }
        if (index == -1) {
            index = this.getAttributeIndex(CORRELATION_COEFFICIENT);
        }
        try {
            tester.multiResultsetFull(this.m_SelectComparisonBase.getCurrentIndex(), index);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)"Failed to analyze experiment!", (Throwable)e);
            return;
        }
        AbstractResultsPanel panel = ((AbstractResultsPanel)((Object)this.m_ComboBoxResults.getSelectedItem())).getClone();
        panel.display(tester.getResultMatrix());
        this.m_History.addEntry(this.m_Formatter.format(new Date()) + " - " + metric.replace("_", " "), (Object)panel);
        this.m_History.setSelectedIndex(this.m_History.count() - 1);
    }

    public static class HistoryPanel
    extends AbstractNamedHistoryPanel<AbstractResultsPanel> {
        private static final long serialVersionUID = 8740813441072965573L;
        protected DefaultAnalysisPanel m_Owner;

        public HistoryPanel(DefaultAnalysisPanel owner) {
            this.m_Owner = owner;
            this.setAllowRemove(true);
            this.setAllowRename(false);
        }

        public void clear() {
            for (AbstractResultsPanel panel : this.m_Entries.values()) {
                panel.cleanUp();
            }
            super.clear();
        }

        public AbstractResultsPanel removeEntry(String name) {
            AbstractResultsPanel result = (AbstractResultsPanel)((Object)super.removeEntry(name));
            if (result != null) {
                result.cleanUp();
            }
            return result;
        }

        protected void updateEntry(String name) {
            this.m_Owner.getPanelRight().removeAll();
            if (name != null && this.hasEntry(name)) {
                this.m_Owner.getPanelRight().add((Component)this.getEntry(name));
            }
            this.m_Owner.getPanelRight().invalidate();
            this.m_Owner.getPanelRight().revalidate();
            this.m_Owner.getPanelRight().doLayout();
            this.m_Owner.getPanelRight().repaint();
        }
    }
}

