/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.analysis;

import adams.core.io.FileUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekamultiexperimenter.analysis.AbstractResultsPanel;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;

public class PlainTextResultsPanel
extends AbstractResultsPanel {
    protected BaseTextAreaWithButtons m_TextAreaResults;
    private static final long serialVersionUID = 3608852939358175057L;
    protected JButton m_ButtonCopy;
    protected JButton m_ButtonSave;
    protected BaseFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        ExtensionFileFilter filter = ExtensionFileFilter.getTextFileFilter();
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.addChoosableFileFilter((FileFilter)filter);
        this.m_FileChooser.setFileFilter((FileFilter)filter);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextAreaResults = new BaseTextAreaWithButtons();
        this.m_TextAreaResults.setTextFont(Fonts.getMonospacedFont());
        this.add((Component)this.m_TextAreaResults, "Center");
        this.m_ButtonCopy = new JButton("Copy", GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonCopy.addActionListener(e -> {
            if (this.m_TextAreaResults.getSelectedText() != null) {
                ClipboardHelper.copyToClipboard((String)this.m_TextAreaResults.getSelectedText());
            } else {
                ClipboardHelper.copyToClipboard((String)this.m_TextAreaResults.getText());
            }
        });
        this.m_TextAreaResults.addToButtonsPanel((Component)this.m_ButtonCopy);
        this.m_ButtonSave = new JButton("Save...", GUIHelper.getIcon((String)"save.gif"));
        this.m_ButtonSave.addActionListener(e -> {
            int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
            if (retVal != 0) {
                return;
            }
            if (!FileUtils.writeToFile((String)this.m_FileChooser.getSelectedFile().getAbsolutePath(), (Object)this.m_TextAreaResults.getText(), (boolean)false)) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save output to:\n" + this.m_FileChooser.getSelectedFile()));
            }
        });
        this.m_TextAreaResults.addToButtonsPanel((Component)this.m_ButtonSave);
    }

    @Override
    public String getResultsName() {
        return "Plain text";
    }

    @Override
    protected void doDisplay() {
        StringBuilder results = new StringBuilder();
        results.append(this.m_Matrix.toStringMatrix());
        results.append(this.m_Matrix.toStringKey());
        this.m_TextAreaResults.setText(results.toString());
        this.m_TextAreaResults.setCaretPosition(0);
    }

    @Override
    public PlainTextResultsPanel getClone() {
        return new PlainTextResultsPanel();
    }
}

