/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.experiment;

import adams.core.Index;
import adams.core.Shortening;
import adams.core.StatusMessageHandler;
import adams.core.StatusMessageHandlerExt;
import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.core.option.WekaCommandLineHandler;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.spreadsheet.rowfinder.ByNumericValue;
import adams.data.spreadsheet.rowfinder.ByStringComparison;
import adams.data.spreadsheet.rowfinder.MultiRowFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.data.weka.classattribute.AbstractClassAttributeHeuristic;
import adams.data.weka.classattribute.LastAttribute;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractResultsHandler;
import adams.gui.tools.wekamultiexperimenter.experiment.ExperimentWithCustomizableRelationNames;
import adams.gui.tools.wekamultiexperimenter.experiment.FileResultsHandler;
import adams.gui.tools.wekamultiexperimenter.experiment.ResettableExperiment;
import adams.multiprocess.AbstractJob;
import adams.multiprocess.JobRunner;
import adams.multiprocess.LocalJobRunner;
import java.io.File;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public abstract class AbstractExperiment
extends AbstractOptionHandler
implements StoppableWithFeedback,
ExperimentWithCustomizableRelationNames,
ResettableExperiment,
SpreadSheetSupporter {
    private static final long serialVersionUID = -345521029095304309L;
    protected boolean m_ResetResults;
    protected Classifier[] m_Classifiers;
    protected PlaceholderFile[] m_Datasets;
    protected AbstractClassAttributeHeuristic m_ClassAttribute;
    protected Index m_ClassLabelIndex;
    protected boolean m_UseFilename;
    protected boolean m_PrefixDatasetsWithIndex;
    protected int m_Runs;
    protected AbstractResultsHandler m_ResultsHandler;
    protected BaseText m_Notes;
    protected transient StatusMessageHandler m_StatusMessageHandler;
    protected transient boolean m_Running;
    protected transient boolean m_Stopped;
    protected transient WekaCommandLineHandler m_CommandLineHandler;
    protected SpreadSheet m_Results;
    protected List<SpreadSheet> m_Generated;
    protected JobRunner m_JobRunner;
    protected transient JobRunner m_ActualJobRunner;
    protected int m_JobCounter;
    protected int m_JobTotal;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reset-results", "resetResults", (Object)false);
        this.m_OptionManager.add("results-handler", "resultsHandler", (Object)new FileResultsHandler());
        this.m_OptionManager.add("classifier", "classifiers", (Object)new Classifier[0]);
        this.m_OptionManager.add("dataset", "datasets", (Object)new PlaceholderFile[0]);
        this.m_OptionManager.add("class-attribute", "classAttribute", (Object)new LastAttribute());
        this.m_OptionManager.add("class-label-index", "classLabelIndex", (Object)new Index("first"));
        this.m_OptionManager.add("use-filename", "useFilename", (Object)false);
        this.m_OptionManager.add("prefix-datasets-with-index", "prefixDatasetsWithIndex", (Object)false);
        this.m_OptionManager.add("runs", "runs", (Object)10, (Number)1, null);
        this.m_OptionManager.add("notes", "notes", (Object)new BaseText());
        this.m_OptionManager.add("jobrunner", "jobRunner", (Object)new LocalJobRunner());
    }

    @Override
    public void setResetResults(boolean value) {
        this.m_ResetResults = value;
        this.reset();
    }

    @Override
    public boolean getResetResults() {
        return this.m_ResetResults;
    }

    public String resetResultsTipText() {
        return "If enabled, any pre-existing results get discarded before the experiment starts.";
    }

    public void setResultsHandler(AbstractResultsHandler value) {
        this.m_ResultsHandler = value;
        this.reset();
    }

    public AbstractResultsHandler getResultsHandler() {
        return this.m_ResultsHandler;
    }

    public String resultWriterTipText() {
        return "The handler to use for the results (read/write).";
    }

    public void setClassifiers(Classifier[] value) {
        this.m_Classifiers = value;
        this.reset();
    }

    public Classifier[] getClassifiers() {
        return this.m_Classifiers;
    }

    public String classifiersTipText() {
        return "The classifiers to evaluate.";
    }

    public void addClassifier(Classifier cls) {
        ArrayList<Classifier> classifiers = new ArrayList<Classifier>(Arrays.asList(this.m_Classifiers));
        classifiers.add(cls);
        this.setClassifiers(classifiers.toArray(new Classifier[classifiers.size()]));
    }

    public void setDatasets(PlaceholderFile[] value) {
        this.m_Datasets = value;
        this.reset();
    }

    public PlaceholderFile[] getDatasets() {
        return this.m_Datasets;
    }

    public String datasetsTipText() {
        return "The datasets to use";
    }

    public void addDataset(PlaceholderFile file) {
        ArrayList<PlaceholderFile> datasets = new ArrayList<PlaceholderFile>(Arrays.asList(this.m_Datasets));
        datasets.add(file);
        this.setDatasets(datasets.toArray(new PlaceholderFile[datasets.size()]));
    }

    public void setClassAttribute(AbstractClassAttributeHeuristic value) {
        this.m_ClassAttribute = value;
        this.reset();
    }

    public AbstractClassAttributeHeuristic getClassAttribute() {
        return this.m_ClassAttribute;
    }

    public String classAttributeTipText() {
        return "The heuristic for determining the class attribute in the datasets (if not explicitly set).";
    }

    public void setClassLabelIndex(Index value) {
        this.m_ClassLabelIndex = value;
        this.reset();
    }

    public Index getClassLabelIndex() {
        return this.m_ClassLabelIndex;
    }

    public String classLabelIndexTipText() {
        return "The index of the class label to use when generating per-class statistics.";
    }

    @Override
    public void setUseFilename(boolean value) {
        this.m_UseFilename = value;
        this.reset();
    }

    @Override
    public boolean getUseFilename() {
        return this.m_UseFilename;
    }

    public String useFilenameTipText() {
        return "If enabled, uses the filename (w/o path) as the name.";
    }

    @Override
    public void setPrefixDatasetsWithIndex(boolean value) {
        this.m_PrefixDatasetsWithIndex = value;
        this.reset();
    }

    @Override
    public boolean getPrefixDatasetsWithIndex() {
        return this.m_PrefixDatasetsWithIndex;
    }

    public String prefixDatasetsWithIndexTipText() {
        return "If enabled, prefixes the dataset name with the index.";
    }

    public void setRuns(int value) {
        this.m_Runs = value;
        this.reset();
    }

    public int getRuns() {
        return this.m_Runs;
    }

    public String runsTipText() {
        return "The number of runs to perform.";
    }

    public void setNotes(BaseText value) {
        this.m_Notes = value;
        this.reset();
    }

    public BaseText getNotes() {
        return this.m_Notes;
    }

    public String notesTipText() {
        return "The notes for this experiment.";
    }

    public void setJobRunner(JobRunner value) {
        this.m_JobRunner = value;
        this.reset();
    }

    public JobRunner getJobRunner() {
        return this.m_JobRunner;
    }

    public String jobRunnerTipText() {
        return "The JobRunner to use for processing the jobs.";
    }

    public void setStatusMessageHandler(StatusMessageHandler value) {
        this.m_StatusMessageHandler = value;
    }

    public StatusMessageHandler getStatusMessageHandler() {
        return this.m_StatusMessageHandler;
    }

    protected String preExecute() {
        return null;
    }

    public SpreadSheet toSpreadSheet() {
        return this.m_Results;
    }

    public Instances toInstances() {
        if (this.m_Results == null) {
            return null;
        }
        SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
        conv.setMaxLabels(this.m_Results.getRowCount() + 1);
        conv.setInput(this.m_Results);
        String msg = conv.convert();
        if (msg != null) {
            this.getLogger().severe("Failed to convert results into Instances: " + msg);
            return null;
        }
        Instances result = (Instances)conv.getOutput();
        return result;
    }

    protected void log(String msg) {
        if (this.m_StatusMessageHandler != null) {
            this.m_StatusMessageHandler.showStatus(msg);
        } else {
            this.getLogger().info(msg);
        }
    }

    protected void log(String msg, Throwable t) {
        if (this.m_StatusMessageHandler != null) {
            this.m_StatusMessageHandler.showStatus(msg + "\n" + Utils.throwableToString((Throwable)t));
        } else {
            this.getLogger().log(Level.SEVERE, msg, t);
        }
    }

    protected SpreadSheet initResults() {
        SpreadSheet result = null;
        if (!this.m_ResetResults) {
            result = this.m_ResultsHandler.read();
        }
        if (result == null) {
            result = new DefaultSpreadSheet();
        }
        return result;
    }

    protected String initExecute() {
        this.m_Stopped = false;
        this.m_Running = true;
        this.m_CommandLineHandler = new WekaCommandLineHandler();
        this.m_Results = this.initResults();
        this.m_Generated = new ArrayList<SpreadSheet>();
        if (this.m_Results == null) {
            return "Failed to initialize results!";
        }
        this.m_ActualJobRunner = (JobRunner)OptionUtils.shallowCopy((Object)this.m_JobRunner);
        return null;
    }

    protected Instances loadDataset(int index) {
        Instances result;
        PlaceholderFile file = this.m_Datasets[index];
        try {
            result = ConverterUtils.DataSource.read((String)file.getAbsolutePath());
            if (result.classIndex() == -1) {
                result.setClassIndex(this.m_ClassAttribute.determineClassAttribute(result));
            }
            if (this.m_UseFilename) {
                result.setRelationName(FileUtils.replaceExtension((File)file, (String)"").getName());
            }
            if (this.m_PrefixDatasetsWithIndex) {
                result.setRelationName(index + 1 + ":" + result.relationName());
            }
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to load dataset: " + file, (Throwable)e);
        }
        return result;
    }

    protected MultiRowFinder configureRowFinder(int currentRun, Classifier cls, Instances data) {
        ByNumericValue run = new ByNumericValue();
        run.setAttributeIndex(new SpreadSheetColumnIndex("Key_Run"));
        run.setMinimum((double)currentRun);
        run.setMinimumIncluded(true);
        run.setMaximum((double)currentRun);
        run.setMaximumIncluded(true);
        ByStringComparison dataset = new ByStringComparison();
        dataset.setAttributeIndex(new SpreadSheetColumnIndex("Key_Dataset"));
        dataset.setMinimum(data.relationName());
        dataset.setMinimumIncluded(true);
        dataset.setMaximum(data.relationName());
        dataset.setMaximumIncluded(true);
        ByStringComparison scheme = new ByStringComparison();
        scheme.setAttributeIndex(new SpreadSheetColumnIndex("Key_Scheme"));
        scheme.setMinimum(cls.getClass().getName());
        scheme.setMinimumIncluded(true);
        scheme.setMaximum(cls.getClass().getName());
        scheme.setMaximumIncluded(true);
        ByStringComparison options = new ByStringComparison();
        options.setAttributeIndex(new SpreadSheetColumnIndex("Key_Scheme_options"));
        options.setMinimum(this.m_CommandLineHandler.joinOptions(this.m_CommandLineHandler.getOptions(cls)));
        options.setMinimumIncluded(true);
        options.setMaximum(this.m_CommandLineHandler.joinOptions(this.m_CommandLineHandler.getOptions(cls)));
        options.setMaximumIncluded(true);
        ByStringComparison version = new ByStringComparison();
        version.setAttributeIndex(new SpreadSheetColumnIndex("Key_Scheme_version_ID"));
        version.setMinimum("" + ObjectStreamClass.lookup(cls.getClass()).getSerialVersionUID());
        version.setMinimumIncluded(true);
        version.setMaximum("" + ObjectStreamClass.lookup(cls.getClass()).getSerialVersionUID());
        version.setMaximumIncluded(true);
        MultiRowFinder result = new MultiRowFinder();
        result.setCombination(MultiRowFinder.Combination.INTERSECT);
        result.setFinders(new RowFinder[]{run, dataset, scheme, options, version});
        return result;
    }

    protected boolean isComplete(int[] rows) {
        return rows.length == 1;
    }

    protected synchronized boolean isRequired(int currentRun, Classifier cls, Instances data) {
        if (this.m_Results.getRowCount() == 0) {
            return true;
        }
        MultiRowFinder finder = this.configureRowFinder(currentRun, cls, data);
        int[] rows = finder.findRows(this.m_Results);
        return !this.isComplete(rows);
    }

    protected synchronized void removeIncomplete(int currentRun, Classifier cls, Instances data) {
        if (this.m_Results.getRowCount() == 0) {
            return;
        }
        MultiRowFinder finder = this.configureRowFinder(currentRun, cls, data);
        int[] rows = finder.findRows(this.m_Results);
        if (rows.length > 0) {
            Arrays.sort(rows);
            for (int i = rows.length - 1; i >= 0; --i) {
                this.m_Results.removeRow(rows[i]);
            }
        }
    }

    protected void showProgress() {
        if (this.m_StatusMessageHandler != null) {
            double perc = (double)this.m_JobCounter / (double)this.m_JobTotal * 100.0;
            String percStr = Utils.doubleToString((double)perc, (int)1) + "%";
            if (this.m_StatusMessageHandler instanceof StatusMessageHandlerExt) {
                ((StatusMessageHandlerExt)this.m_StatusMessageHandler).showStatus(false, percStr);
            } else {
                this.m_StatusMessageHandler.showStatus(percStr);
            }
        }
    }

    protected void clearProgress() {
        if (this.m_StatusMessageHandler instanceof StatusMessageHandlerExt) {
            ((StatusMessageHandlerExt)this.m_StatusMessageHandler).showStatus(false, null);
        } else {
            this.m_StatusMessageHandler.showStatus(null);
        }
    }

    public void initProgress() {
        this.m_JobCounter = 0;
        this.m_JobTotal = this.m_Datasets.length * this.m_Classifiers.length * this.m_Runs;
        this.clearProgress();
    }

    public void incProgress() {
        ++this.m_JobCounter;
        this.showProgress();
    }

    public synchronized void appendResults(SpreadSheet results) {
        this.m_Generated.add(results);
    }

    protected abstract AbstractExperimentJob<? extends AbstractExperiment> evaluate(int var1, Classifier var2, Instances var3);

    protected String doExecute() {
        this.initProgress();
        this.m_ActualJobRunner.start();
        for (int d = 0; d < this.m_Datasets.length && !this.m_Stopped; ++d) {
            this.log("Loading dataset #" + (d + 1) + ": " + this.m_Datasets[d]);
            Instances data = this.loadDataset(d);
            if (data == null) {
                return "Failed to load dataset: " + this.m_Datasets[d];
            }
            for (int currentRun = 1; currentRun <= this.m_Runs && !this.m_Stopped; ++currentRun) {
                for (int c = 0; c < this.m_Classifiers.length && !this.m_Stopped; ++c) {
                    if (!this.isRequired(currentRun, this.m_Classifiers[c], data)) {
                        this.log("Run " + currentRun + ": " + data.relationName() + " on " + AbstractExperiment.shortenCommandLine(this.m_Classifiers[c]) + " already present!");
                        continue;
                    }
                    this.removeIncomplete(currentRun, this.m_Classifiers[c], data);
                    this.log("Submitting run " + currentRun + ": " + data.relationName() + " on " + AbstractExperiment.shortenCommandLine(this.m_Classifiers[c]));
                    this.m_ActualJobRunner.add(this.evaluate(currentRun, this.m_Classifiers[c], data));
                }
            }
        }
        this.log("Waiting for jobs to finish...");
        this.m_ActualJobRunner.stop();
        while (this.m_ActualJobRunner.isRunning()) {
            Utils.wait((LoggingObject)this, (int)1000, (int)50);
        }
        this.m_ActualJobRunner = null;
        this.clearProgress();
        if (this.m_Stopped) {
            this.log("Experiment stopped!");
            return "Experiment stopped!";
        }
        return null;
    }

    protected void postExecute(boolean success) {
        String msg;
        for (int i = 0; i < this.m_Generated.size(); ++i) {
            if (this.m_Results.getRowCount() == 0) {
                this.m_Results = this.m_Generated.get(i);
                continue;
            }
            SpreadSheetHelper.append((SpreadSheet)this.m_Results, (SpreadSheet)this.m_Generated.get(i), (boolean)true);
        }
        if (this.m_Results.getRowCount() > 0 && (msg = this.m_ResultsHandler.write(this.m_Results)) != null) {
            this.log("Failed to store the results: " + msg);
        }
    }

    public String execute() {
        this.log("Init-Execute...");
        String result = this.initExecute();
        if (result == null) {
            this.log("Pre-Execute...");
            result = this.preExecute();
        }
        if (result == null) {
            this.log("Do-Execute...");
            result = this.doExecute();
            this.log("Post-Execute...");
            this.postExecute(result == null && !this.m_Stopped);
        }
        if (result != null) {
            this.log(result);
        }
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
        if (this.m_ActualJobRunner != null) {
            this.m_ActualJobRunner.terminate(false);
        }
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public static String shortenCommandLine(Classifier cls) {
        return Shortening.shortenEnd((String)OptionUtils.getCommandLine((Object)cls), (int)256);
    }

    public static abstract class AbstractExperimentJob<T extends AbstractExperiment>
    extends AbstractJob {
        private static final long serialVersionUID = -2223939382172900336L;
        protected T m_Owner;
        protected int m_Run;
        protected Classifier m_Classifier;
        protected Instances m_Data;
        protected Index m_ClassLabelIndex;
        protected SpreadSheet m_Results;

        public AbstractExperimentJob(T owner, int run, Classifier classifier, Instances data) {
            this.m_Owner = owner;
            this.m_Run = run;
            this.m_Classifier = classifier;
            this.m_Data = data;
            this.m_ClassLabelIndex = ((AbstractExperiment)this.m_Owner).getClassLabelIndex().getClone();
            this.m_ClassLabelIndex.setMax(this.m_Data.classAttribute().numValues());
            this.m_Results = new DefaultSpreadSheet();
        }

        protected void addMetric(SpreadSheet results, String name, Object value) {
            HeaderRow header = results.getHeaderRow();
            int index = header.indexOfContent(name);
            if (index == -1) {
                results.insertColumn(results.getColumnCount(), name);
                index = results.getColumnCount() - 1;
            }
            DataRow row = results.getRow(results.getRowCount() - 1);
            row.addCell(index).setNative(value);
        }

        protected void addMetrics(SpreadSheet results, int currentRun, Classifier cls, Instances data, Evaluation eval) {
            results.addRow();
            WekaCommandLineHandler cmdlineHandler = new WekaCommandLineHandler();
            this.addMetric(results, "Key_Run", currentRun);
            this.addMetric(results, "Key_Dataset", data.relationName());
            this.addMetric(results, "Key_Scheme", cls.getClass().getName());
            this.addMetric(results, "Key_Scheme_options", cmdlineHandler.joinOptions(cmdlineHandler.getOptions(cls)));
            this.addMetric(results, "Key_Scheme_version_ID", "" + ObjectStreamClass.lookup(cls.getClass()).getSerialVersionUID());
            boolean nominal = eval.getHeader().classAttribute().isNominal();
            this.m_ClassLabelIndex.setMax(eval.getHeader().classAttribute().numValues());
            int classLabel = this.m_ClassLabelIndex.getIntIndex();
            for (EvaluationStatistic stat : EvaluationStatistic.values()) {
                if (stat.isOnlyNominal() && !nominal || stat.isOnlyNumeric() && nominal) continue;
                String metric = stat.toDisplayShort().replace(" ", "_");
                try {
                    this.addMetric(results, metric, EvaluationHelper.getValue(eval, stat, classLabel));
                }
                catch (Exception e) {
                    this.m_Owner.getLogger().log(Level.SEVERE, "Failed to retrieve statistic: " + (Object)((Object)stat), (Throwable)e);
                }
            }
        }

        protected String preProcessCheck() {
            return null;
        }

        protected abstract void evaluate();

        protected void process() throws Exception {
            this.evaluate();
            ((AbstractExperiment)this.m_Owner).appendResults(this.m_Results);
            ((AbstractExperiment)this.m_Owner).incProgress();
        }

        protected String postProcessCheck() {
            return null;
        }

        public String toString() {
            return "run=" + this.m_Run + ", dataset=" + this.m_Data.relationName() + ", classifier=" + AbstractExperiment.shortenCommandLine(this.m_Classifier);
        }
    }
}

