/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.io;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractAdamsExperimentReader;
import adams.data.io.output.AbstractAdamsExperimentWriter;
import adams.gui.chooser.AdamsExperimentFileChooser;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import adams.gui.tools.wekamultiexperimenter.experiment.CrossValidationExperiment;
import adams.gui.tools.wekamultiexperimenter.io.AbstractAdamsExperimentIO;
import adams.gui.tools.wekamultiexperimenter.runner.AbstractExperimentRunner;
import adams.gui.tools.wekamultiexperimenter.runner.AdamsExperimentRunner;
import java.io.File;
import java.util.logging.Level;

public class DefaultAdamsExperimentIO
extends AbstractAdamsExperimentIO<AbstractExperiment> {
    private static final long serialVersionUID = -7678768486122004558L;

    @Override
    public AbstractExperiment create() {
        return new CrossValidationExperiment();
    }

    @Override
    public AbstractExperiment load(File file) {
        AdamsExperimentFileChooser chooser = (AdamsExperimentFileChooser)this.getFileChooser();
        try {
            AbstractAdamsExperimentReader reader = chooser.getReaderForFile(file);
            if (reader == null) {
                throw new Exception("No reader found for: " + file);
            }
            AbstractExperiment result = reader.read(new PlaceholderFile(file));
            return result;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load experiment from " + file + "!", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean save(AbstractExperiment exp, File file) {
        AdamsExperimentFileChooser chooser = (AdamsExperimentFileChooser)this.getFileChooser();
        try {
            AbstractAdamsExperimentWriter writer = chooser.getWriterForFile(file);
            if (writer == null) {
                throw new Exception("No writer found for: " + file);
            }
            String msg = writer.write(new PlaceholderFile(file), exp);
            if (msg != null) {
                throw new Exception(msg);
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write experiment to " + file + "!", (Throwable)e);
            return false;
        }
    }

    @Override
    public AbstractExperimentRunner createRunner(ExperimenterPanel owner) throws Exception {
        return new AdamsExperimentRunner(owner);
    }
}

