/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.core.BaseList;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupOptionPanel;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;

public class ClassifierPanel
extends AbstractSetupOptionPanel {
    private static final long serialVersionUID = -832431512063524253L;
    protected GenericObjectEditorPanel m_PanelGOE;
    protected BaseListWithButtons m_List;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonEdit;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonUp;
    protected JButton m_ButtonDown;
    protected DefaultListModel<String> m_Model;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Model = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        this.m_PanelGOE = new GenericObjectEditorPanel(Classifier.class, (Object)new ZeroR(), true);
        this.add((Component)this.m_PanelGOE, "North");
        this.m_List = new BaseListWithButtons(this.m_Model);
        this.add((Component)this.m_List, "Center");
        this.m_ButtonAdd = new JButton("Add");
        this.m_ButtonAdd.addActionListener(e -> {
            this.m_Model.addElement(OptionUtils.getCommandLine((Object)this.m_PanelGOE.getCurrent()));
            this.modified();
            this.update();
        });
        this.m_ButtonEdit = new JButton("Edit");
        this.m_ButtonEdit.addActionListener(e -> {
            try {
                this.m_PanelGOE.setCurrent(OptionUtils.forAnyCommandLine(Classifier.class, (String)((String)this.m_List.getSelectedValue())));
                this.m_PanelGOE.choose();
                this.m_Model.setElementAt(OptionUtils.getCommandLine((Object)this.m_PanelGOE.getCurrent()), this.m_List.getSelectedIndex());
                this.modified();
            }
            catch (Exception ex) {
                System.err.println("Failed to instantiate classifier: " + this.m_List.getSelectedValue());
                ex.printStackTrace();
            }
            this.update();
        });
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(e -> {
            int[] indices = this.m_List.getSelectedIndices();
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.m_Model.remove(indices[i]);
            }
            this.modified();
            this.update();
        });
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(e -> {
            this.m_Model.clear();
            this.modified();
            this.update();
        });
        this.m_ButtonUp = new JButton("Up");
        this.m_ButtonUp.addActionListener(e -> {
            this.m_List.moveUp();
            this.modified();
            this.update();
        });
        this.m_ButtonDown = new JButton("Down");
        this.m_ButtonDown.addActionListener(e -> {
            this.m_List.moveDown();
            this.modified();
            this.update();
        });
        this.m_List.addToButtonsPanel((Component)this.m_ButtonAdd);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonEdit);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemoveAll);
        this.m_List.addToButtonsPanel((Component)new JLabel(""));
        this.m_List.addToButtonsPanel((Component)this.m_ButtonUp);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonDown);
        this.m_List.setDoubleClickButton(this.m_ButtonEdit);
        this.m_List.addListSelectionListener(e -> this.update());
        ((BaseList)this.m_List.getComponent()).addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick((MouseEvent)e)) {
                    ClassifierPanel.this.showListPopup(e);
                    e.consume();
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    @Override
    protected void update() {
        super.update();
        this.m_ButtonEdit.setEnabled(this.m_List.getSelectedIndices().length == 1);
        this.m_ButtonRemove.setEnabled(this.m_List.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_Model.getSize() > 0);
        this.m_ButtonUp.setEnabled(this.m_List.canMoveUp());
        this.m_ButtonDown.setEnabled(this.m_List.canMoveDown());
    }

    protected void showListPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setEnabled(this.m_List.getSelectedIndices().length == 1);
        menuitem.addActionListener(ae -> ClipboardHelper.copyToClipboard((String)this.m_Model.get(this.m_List.getSelectedIndex())));
        menu.add(menuitem);
        menuitem = new JMenuItem("Replace with...");
        menuitem.setEnabled(this.m_List.getSelectedIndices().length == 1);
        menuitem.addActionListener(ae -> {
            String input = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter classifier setup");
            if (input == null) {
                return;
            }
            try {
                OptionUtils.forAnyCommandLine(Classifier.class, (String)input);
                this.m_Model.set(this.m_List.getSelectedIndex(), input);
            }
            catch (Exception ex) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Not a valid classifier setup!\n" + Utils.throwableToString((Throwable)ex)));
            }
        });
        menu.add(menuitem);
        menu.show((Component)this.m_List, e.getX(), e.getY());
    }

    public void setClassifiers(Classifier[] value) {
        this.m_IgnoreChanges = true;
        this.m_Model.clear();
        for (Classifier c : value) {
            this.m_Model.addElement(OptionUtils.getCommandLine((Object)c));
        }
        this.m_IgnoreChanges = false;
    }

    public Classifier[] getClassifiers() {
        Classifier[] result = new Classifier[this.m_Model.getSize()];
        for (int i = 0; i < this.m_Model.getSize(); ++i) {
            try {
                result[i] = (Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)this.m_Model.getElementAt(i));
                continue;
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate classifier: " + this.m_Model.getElementAt(i), (Throwable)e);
                result[i] = new ZeroR();
            }
        }
        return result;
    }
}

