/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.core.ClassLocator;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.gui.core.BaseScrollPane;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import adams.gui.visualization.debug.objectrenderer.PlainTextRenderer;
import adams.gui.visualization.debug.objectrenderer.SpreadSheetRenderer;
import adams.gui.visualization.instances.InstancesTable;
import java.awt.Component;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstancesRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;

    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(Instances.class, (Class)cls) || ClassLocator.hasInterface(Instance.class, (Class)cls);
    }

    protected String doRender(Object obj, JPanel panel) {
        if (obj instanceof Instances) {
            Instances data = (Instances)obj;
            if (data.numInstances() == 0) {
                DefaultSpreadSheet sheet = new DefaultSpreadSheet();
                HeaderRow row = sheet.getHeaderRow();
                row.addCell("I").setContentAsString("Index");
                row.addCell("N").setContentAsString("Name");
                row.addCell("T").setContentAsString("Type");
                row.addCell("C").setContentAsString("Class");
                for (int i = 0; i < data.numAttributes(); ++i) {
                    row = sheet.addRow();
                    row.addCell("I").setContent(Integer.valueOf(i + 1));
                    row.addCell("N").setContentAsString(data.attribute(i).name());
                    row.addCell("T").setContentAsString(Attribute.typeToString((Attribute)data.attribute(i)));
                    row.addCell("C").setContent(i == data.classIndex() ? "true" : "");
                }
                SpreadSheetRenderer sprenderer = new SpreadSheetRenderer();
                sprenderer.render((Object)sheet, panel);
            } else {
                InstancesTable table = new InstancesTable(data);
                BaseScrollPane scrollPane = new BaseScrollPane((Component)((Object)table));
                panel.add((Component)scrollPane, "Center");
            }
        } else {
            Instance inst = (Instance)obj;
            if (inst.dataset() != null) {
                Instances data = new Instances(inst.dataset(), 0);
                data.add((Instance)inst.copy());
                InstancesTable table = new InstancesTable(data);
                BaseScrollPane scrollPane = new BaseScrollPane((Component)((Object)table));
                panel.add((Component)scrollPane, "Center");
            } else {
                PlainTextRenderer plain = new PlainTextRenderer();
                plain.render(obj, panel);
            }
        }
        return null;
    }
}

