/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances;

import adams.core.Range;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.GUIHelper;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.TableRowRange;
import adams.gui.core.UndoHandlerWithQuickAccess;
import adams.gui.visualization.instances.AttributeValueCellRenderer;
import adams.gui.visualization.instances.InstancesTableModel;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.converters.AbstractFileSaver;

public class InstancesTable
extends SortableAndSearchableTable
implements Undoable {
    private static final long serialVersionUID = -1408763296714340976L;
    protected AttributeValueCellRenderer m_Renderer;
    protected WekaFileChooser m_FileChooser;
    protected HashMap<String, Object> m_LastSetup;
    protected HashSet<ChangeListener> m_ChangeListeners;

    public InstancesTable(Instances data) {
        this(new InstancesTableModel(data));
    }

    public InstancesTable(InstancesTableModel model) {
        super((TableModel)model);
    }

    protected void initGUI() {
        super.initGUI();
        this.m_FileChooser = new WekaFileChooser();
        this.m_Renderer = new AttributeValueCellRenderer();
        this.m_LastSetup = new HashMap();
        this.m_ChangeListeners = new HashSet();
        this.setAutoResizeMode(0);
        this.addHeaderPopupMenuListener(e -> this.showHeaderPopup(e));
        this.addCellPopupMenuListener(e -> this.showCellPopup(e));
    }

    public synchronized void setModel(TableModel model) {
        if (!(model instanceof InstancesTableModel)) {
            throw new IllegalArgumentException("Model must be derived from " + InstancesTableModel.class.getName() + ", provided: " + model.getClass().getName());
        }
        super.setModel(model);
    }

    public void setUndoHandler(UndoHandlerWithQuickAccess value) {
        ((InstancesTableModel)this.getUnsortedModel()).setUndoHandler(value);
    }

    public UndoHandlerWithQuickAccess getUndoHandler() {
        return ((InstancesTableModel)this.getUnsortedModel()).getUndoHandler();
    }

    public boolean isUndoEnabled() {
        return ((InstancesTableModel)this.getUnsortedModel()).isUndoEnabled();
    }

    public void setUndoEnabled(boolean enabled) {
        ((InstancesTableModel)this.getUnsortedModel()).setUndoEnabled(enabled);
    }

    public void clearUndo() {
        ((InstancesTableModel)this.getUnsortedModel()).clearUndo();
    }

    public boolean canUndo() {
        return ((InstancesTableModel)this.getUnsortedModel()).canUndo();
    }

    public void undo() {
        ((InstancesTableModel)this.getModel()).undo();
        this.setOptimalColumnWidth();
        this.notifyChangeListeners();
    }

    public void addUndoPoint() {
        ((InstancesTableModel)this.getModel()).addUndoPoint();
    }

    public boolean isReadOnly() {
        return ((InstancesTableModel)this.getUnsortedModel()).isReadOnly();
    }

    public void setReadOnly(boolean value) {
        ((InstancesTableModel)this.getUnsortedModel()).setReadOnly(value);
    }

    public void setInstances(Instances data) {
        this.setModel(new InstancesTableModel(data));
    }

    public Instances getInstances() {
        return ((InstancesTableModel)this.getUnsortedModel()).getInstances();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.m_Renderer;
    }

    protected void showHeaderPopup(MouseEvent e) {
        BasePopupMenu menu = this.createHeaderPopup(e);
        menu.showAbsolute((Component)this.getTableHeader(), e);
    }

    protected BasePopupMenu createHeaderPopup(MouseEvent e) {
        JMenuItem menuitem;
        BasePopupMenu menu = new BasePopupMenu();
        int row = this.rowAtPoint(e.getPoint());
        int actRow = this.getActualRow(row);
        int col = this.tableHeader.columnAtPoint(e.getPoint());
        int actCol = col - 1;
        InstancesTableModel instModel = (InstancesTableModel)this.getUnsortedModel();
        if (instModel.isUndoEnabled()) {
            menuitem = new JMenuItem("Undo", GUIHelper.getIcon((String)"undo.gif"));
            menuitem.setEnabled(this.canUndo());
            menuitem.addActionListener(ae -> instModel.undo());
            menu.add(menuitem);
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Rename...", GUIHelper.getEmptyIcon());
        menuitem.addActionListener(ae -> {
            String newName = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter new name", (String)this.getInstances().attribute(col - 1).name());
            if (newName != null) {
                instModel.renameAttributeAt(col, newName);
                this.setOptimalColumnWidth();
                this.notifyChangeListeners();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Delete", GUIHelper.getIcon((String)"delete.gif"));
        menuitem.addActionListener(ae -> {
            int retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)("Delete attribute '" + this.getInstances().attribute(col - 1).name() + "'?"));
            if (retVal == 0) {
                instModel.deleteAttributeAt(col);
                this.setOptimalColumnWidth();
                this.notifyChangeListeners();
            }
        });
        menu.add(menuitem);
        InstancesTablePopupMenuItemHelper.addToPopupMenu(this, (JPopupMenu)menu, false, actRow, row, actCol);
        return menu;
    }

    protected void showCellPopup(MouseEvent e) {
        BasePopupMenu menu = this.createCellPopup(e);
        menu.showAbsolute((Component)((Object)this), e);
    }

    protected BasePopupMenu createCellPopup(MouseEvent e) {
        JMenuItem menuitem;
        BasePopupMenu menu = new BasePopupMenu();
        int col = this.columnAtPoint(e.getPoint());
        int actCol = col - 1;
        int row = this.rowAtPoint(e.getPoint());
        int actRow = this.getActualRow(row);
        int[] selRows = this.getSelectedRows();
        InstancesTableModel instModel = (InstancesTableModel)this.getUnsortedModel();
        Range range = new Range();
        range.setMax(this.getRowCount());
        range.setIndices(selRows);
        if (instModel.isUndoEnabled()) {
            menuitem = new JMenuItem("Undo", GUIHelper.getIcon((String)"undo.gif"));
            menuitem.setEnabled(this.canUndo());
            menuitem.addActionListener(ae -> instModel.undo());
            menu.add(menuitem);
        }
        menuitem = new JMenuItem("Invert selection", GUIHelper.getEmptyIcon());
        menuitem.addActionListener(ae -> this.invertRowSelection());
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Delete", GUIHelper.getIcon((String)"delete.gif"));
        menuitem.setEnabled(selRows.length > 0);
        menuitem.addActionListener(ae -> {
            int retVal;
            String msg = "Delete row";
            if (selRows.length > 1) {
                msg = msg + "s";
            }
            if ((retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)(msg = msg + " " + range.getRange() + "?"))) != 0) {
                return;
            }
            int[] actRows = new int[selRows.length];
            for (int i = 0; i < selRows.length; ++i) {
                actRows[i] = this.getActualRow(selRows[i]);
            }
            instModel.deleteInstances(actRows);
            this.notifyChangeListeners();
        });
        menu.add(menuitem);
        menu.addSeparator();
        JMenu submenu = new JMenu("Save");
        submenu.setIcon(GUIHelper.getIcon((String)"save.gif"));
        menu.add((JMenuItem)submenu);
        menuitem = new JMenuItem("Save all...");
        menuitem.addActionListener(ae -> this.saveAs(TableRowRange.ALL));
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save selected...");
        menuitem.addActionListener(ae -> this.saveAs(TableRowRange.SELECTED));
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save visible...");
        menuitem.addActionListener(ae -> this.saveAs(TableRowRange.VISIBLE));
        submenu.add(menuitem);
        InstancesTablePopupMenuItemHelper.addToPopupMenu(this, (JPopupMenu)menu, true, actRow, row, actCol);
        return menu;
    }

    protected void saveAs(TableRowRange range) {
        Instances data;
        int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        AbstractFileSaver saver = (AbstractFileSaver)this.m_FileChooser.getWriter();
        File file = this.m_FileChooser.getSelectedFile();
        Instances original = this.getInstances();
        switch (range) {
            case ALL: {
                data = original;
                break;
            }
            case SELECTED: {
                data = new Instances(original, 0);
                int[] selRows = this.getSelectedRows();
                for (int i = 0; i < selRows.length; ++i) {
                    data.add((Instance)original.instance(this.getActualRow(selRows[i])).copy());
                }
                break;
            }
            case VISIBLE: {
                data = new Instances(original, 0);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    data.add((Instance)original.instance(this.getActualRow(i)).copy());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled range type: " + range);
            }
        }
        try {
            saver.setFile(file);
            saver.setInstances(data);
            saver.writeBatch();
        }
        catch (Exception ex) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data (" + range + ") to: " + file), (Throwable)ex);
        }
    }

    protected String createLastSetupKey(Class cls, boolean plot, boolean row) {
        return cls.getName() + "-" + (plot ? "plot" : "process") + "-" + (row ? "row" : "column");
    }

    public void addLastSetup(Class cls, boolean plot, boolean row, Object setup) {
        this.m_LastSetup.put(this.createLastSetupKey(cls, plot, row), setup);
    }

    public Object getLastSetup(Class cls, boolean plot, boolean row) {
        return this.m_LastSetup.get(this.createLastSetupKey(cls, plot, row));
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected synchronized void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent((Object)this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }
}

