/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.option.AbstractOptionHandler;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.ProcessCell;
import java.awt.Component;
import weka.core.Instances;

public abstract class AbstractProcessCell
extends AbstractOptionHandler
implements ProcessCell {
    private static final long serialVersionUID = -1050881505327794503L;

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    @Override
    public String getIconName() {
        return null;
    }

    protected String check(InstancesTable table, Instances data, int actRow, int selRow, int column) {
        if (table == null) {
            return "No source table available!";
        }
        if (data == null) {
            return "No instances available!";
        }
        if (actRow < 0) {
            return "Negative row index!";
        }
        if (actRow >= data.numInstances()) {
            return "Row index too large: " + (actRow + 1) + " > " + data.numInstances();
        }
        if (column < 0) {
            return "Negative column index!";
        }
        if (column >= data.numAttributes()) {
            return "Column index too large: " + (column + 1) + " > " + data.numAttributes();
        }
        return null;
    }

    protected abstract boolean doProcessCell(InstancesTable var1, Instances var2, int var3, int var4, int var5);

    @Override
    public boolean processCell(InstancesTable table, Instances data, int actRow, int selRow, int column) {
        boolean result;
        String error = this.check(table, data, actRow, selRow, column);
        boolean bl = result = error == null;
        if (result) {
            result = this.doProcessCell(table, data, actRow, selRow, column);
        } else {
            GUIHelper.showErrorMessage((Component)((Object)table), (String)("Failed to process cell " + (actRow + 1) + "/" + (column + 1) + "\n" + error));
        }
        return result;
    }
}

