/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.data.statistics.ArrayHistogram;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.statistics.HistogramFactory;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import weka.core.Instances;

public class Histogram
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -2452746814708360637L;

    public String globalInfo() {
        return "Allows to plot either a row or a column from a instances";
    }

    @Override
    public String getMenuItem() {
        return "Histogram...";
    }

    @Override
    public String getIconName() {
        return "histogram.png";
    }

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    protected void plot(InstancesTable table, Instances data, boolean isColumn, int index) {
        HistogramFactory.SetupDialog setup = GUIHelper.getParentDialog((Container)((Object)table)) != null ? HistogramFactory.getSetupDialog((Dialog)GUIHelper.getParentDialog((Container)((Object)table)), (Dialog.ModalityType)Dialog.ModalityType.DOCUMENT_MODAL) : HistogramFactory.getSetupDialog((Frame)GUIHelper.getParentFrame((Container)((Object)table)), (boolean)true);
        setup.setDefaultCloseOperation(2);
        setup.setTitle("Histogram setup");
        ArrayHistogram last = (ArrayHistogram)table.getLastSetup(this.getClass(), true, !isColumn);
        if (last == null) {
            last = new ArrayHistogram();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)table)));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        last = (ArrayHistogram)setup.getCurrent();
        table.addLastSetup(this.getClass(), true, !isColumn, last);
        TDoubleArrayList list = new TDoubleArrayList();
        if (isColumn) {
            int col = index + 1;
            for (int i = 0; i < table.getRowCount(); ++i) {
                Object value = table.getValueAt(i, col);
                if (value == null || !Utils.isDouble((String)value.toString())) continue;
                list.add(Utils.toDouble((String)value.toString()).doubleValue());
            }
        } else {
            int row = index;
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (!data.attribute(i).isNumeric() || data.instance(row).isMissing(i)) continue;
                list.add(data.instance(row).value(i));
            }
        }
        last.clear();
        HistogramFactory.Dialog dialog = GUIHelper.getParentDialog((Container)((Object)table)) != null ? HistogramFactory.getDialog((Dialog)GUIHelper.getParentDialog((Container)((Object)table)), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : HistogramFactory.getDialog((Frame)GUIHelper.getParentFrame((Container)((Object)table)), (boolean)false);
        dialog.setDefaultCloseOperation(2);
        if (isColumn) {
            dialog.add(last, list.toArray(), "Column " + (index + 1) + "/" + data.attribute(index).name());
        } else {
            dialog.add(last, list.toArray(), "Row " + (index + 1));
        }
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)table)));
        dialog.setVisible(true);
    }

    @Override
    public boolean plotColumn(InstancesTable table, Instances data, int column) {
        this.plot(table, data, true, column);
        return true;
    }

    @Override
    public boolean plotRow(InstancesTable table, Instances data, int actRow, int selRow) {
        this.plot(table, data, false, actRow);
        return true;
    }
}

