/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.ClassLister;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import adams.gui.visualization.instances.instancestable.ProcessCell;
import adams.gui.visualization.instances.instancestable.ProcessColumn;
import adams.gui.visualization.instances.instancestable.ProcessRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import weka.core.Instances;

public class InstancesTablePopupMenuItemHelper {
    protected static List<InstancesTablePopupMenuItem> getItems(Class cls) {
        String[] classes;
        ArrayList<InstancesTablePopupMenuItem> result = new ArrayList<InstancesTablePopupMenuItem>();
        for (String c : classes = ClassLister.getSingleton().getClassnames(cls)) {
            try {
                result.add((InstancesTablePopupMenuItem)Class.forName(c).newInstance());
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append("Failed to instantiate InstancesTable menu item: " + c, (Throwable)e);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    protected static void addAction(InstancesTable table, Instances data, boolean isRow, int actRow, int selRow, int column, JMenuItem menuitem, InstancesTablePopupMenuItem item) {
        if (isRow) {
            if (item instanceof PlotRow) {
                menuitem.addActionListener(e -> ((PlotRow)item).plotRow(table, data, actRow, selRow));
            } else if (item instanceof ProcessRow) {
                menuitem.addActionListener(e -> ((ProcessRow)item).processRow(table, data, actRow, selRow));
            } else if (item instanceof ProcessCell) {
                menuitem.addActionListener(e -> ((ProcessCell)item).processCell(table, data, actRow, selRow, column));
            }
        } else if (item instanceof PlotColumn) {
            menuitem.addActionListener(e -> ((PlotColumn)item).plotColumn(table, data, column));
        } else if (item instanceof ProcessColumn) {
            menuitem.addActionListener(e -> ((ProcessColumn)item).processColumn(table, data, column));
        }
    }

    protected static void addToPopupMenu(InstancesTable table, boolean isRow, int actRow, int selRow, int column, JPopupMenu menu, List<InstancesTablePopupMenuItem> items) {
        if (items.size() == 0) {
            return;
        }
        Instances data = table.getInstances();
        if (menu.getComponent(menu.getComponentCount() - 1) instanceof JMenuItem) {
            menu.addSeparator();
        }
        for (InstancesTablePopupMenuItem item : items) {
            JMenuItem menuitem = new JMenuItem(item.getMenuItem());
            if (item.getIconName() != null) {
                menuitem.setIcon(GUIHelper.getIcon((String)item.getIconName()));
            }
            InstancesTablePopupMenuItemHelper.addAction(table, data, isRow, actRow, selRow, column, menuitem, item);
            menu.add(menuitem);
        }
    }

    public static void addToPopupMenu(InstancesTable table, JPopupMenu menu, boolean isRow, int actRow, int selRow, int column) {
        menu.addSeparator();
        if (isRow) {
            InstancesTablePopupMenuItemHelper.addToPopupMenu(table, true, actRow, selRow, column, menu, InstancesTablePopupMenuItemHelper.getItems(PlotRow.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(table, true, actRow, selRow, column, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessRow.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(table, true, actRow, selRow, column, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessCell.class));
        } else {
            InstancesTablePopupMenuItemHelper.addToPopupMenu(table, false, actRow, selRow, column, menu, InstancesTablePopupMenuItemHelper.getItems(PlotColumn.class));
            InstancesTablePopupMenuItemHelper.addToPopupMenu(table, false, actRow, selRow, column, menu, InstancesTablePopupMenuItemHelper.getItems(ProcessColumn.class));
        }
    }
}

