/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.source.StorageValue;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.MakePlotContainer;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItem;
import adams.gui.visualization.instances.instancestable.PlotColumn;
import adams.gui.visualization.instances.instancestable.PlotRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.SwingWorker;
import weka.core.Instances;

public class SimplePlot
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -5624002368001818142L;
    public static final int MAX_POINTS = 1000;

    public String globalInfo() {
        return "Allows to generate a simple plot from a instances row or column";
    }

    @Override
    public String getMenuItem() {
        return "Simple plot...";
    }

    @Override
    public String getIconName() {
        return "plot.gif";
    }

    @Override
    public int compareTo(InstancesTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    protected void plot(final InstancesTable table, Instances data, final boolean isColumn, int index) {
        List<Double> list;
        int numPoints;
        int n = numPoints = isColumn ? data.numInstances() : data.numAttributes();
        if (numPoints > 1000) {
            String newPoints = GUIHelper.showInputDialog(null, (String)"More than 1000 data points to plot - enter sample size:", (String)("" + numPoints));
            if (newPoints == null) {
                return;
            }
            if (!Utils.isInteger((String)newPoints)) {
                return;
            }
            if (Integer.parseInt(newPoints) != numPoints) {
                numPoints = Integer.parseInt(newPoints);
            }
        } else {
            numPoints = -1;
        }
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)((Object)table)) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)((Object)table)), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)((Object)table)), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(Actor.class);
        setup.getGOEEditor().setCanChangeClassInDialog(false);
        adams.flow.sink.SimplePlot last = (adams.flow.sink.SimplePlot)table.getLastSetup(this.getClass(), true, !isColumn);
        if (last == null) {
            last = new adams.flow.sink.SimplePlot();
            last.setNoToolTips(true);
            last.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)table)));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        last = (adams.flow.sink.SimplePlot)setup.getCurrent();
        table.addLastSetup(this.getClass(), true, !isColumn, last);
        ArrayList<Double> tmp = new ArrayList<Double>();
        boolean sorted = false;
        boolean asc = table.isAscending();
        if (isColumn) {
            int col = index + 1;
            sorted = table.getSortColumn() == col;
            for (int i = 0; i < table.getRowCount(); ++i) {
                Object value = table.getValueAt(i, col);
                if (value == null || !Utils.isDouble((String)value.toString())) continue;
                tmp.add(Utils.toDouble((String)value.toString()));
            }
        } else {
            int row = index;
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (!data.attribute(i).isNumeric() || data.instance(row).isMissing(i)) continue;
                tmp.add(data.instance(row).value(i));
            }
        }
        if (numPoints > -1) {
            Collections.shuffle(tmp, new Random(1L));
            list = tmp.subList(0, numPoints);
            if (sorted) {
                Collections.sort(list);
                if (!asc) {
                    Collections.reverse(list);
                }
            }
        } else {
            list = tmp;
        }
        final String title = isColumn ? "Column " + (index + 1) + "/" + data.attribute(index).name() : "Row " + (index + 1);
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                flow.setDefaultCloseOperation(2);
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add((Actor)sv);
                ArrayToSequence a2s = new ArrayToSequence();
                flow.add((Actor)a2s);
                MakePlotContainer mpc = new MakePlotContainer();
                mpc.setPlotName(title);
                flow.add((Actor)mpc);
                Object last = table.getLastSetup(SimplePlot.this.getClass(), true, !isColumn);
                adams.flow.sink.SimplePlot plot = (adams.flow.sink.SimplePlot)((adams.flow.sink.SimplePlot)last).shallowCopy();
                plot.setShortTitle(true);
                plot.setShowSidePanel(false);
                plot.setName(title);
                plot.setX(-2);
                plot.setY(-2);
                flow.add((Actor)plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), (Object)list.toArray(new Double[list.size()]));
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    @Override
    public boolean plotColumn(InstancesTable table, Instances data, int column) {
        this.plot(table, data, true, column);
        return true;
    }

    @Override
    public boolean plotRow(InstancesTable table, Instances data, int actRow, int selRow) {
        this.plot(table, data, false, actRow);
        return true;
    }
}

