/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.core.Utils;
import adams.core.exception.NotImplementedException;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DoubleCell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.ml.data.InstancesView;
import java.util.ArrayList;
import java.util.Collection;
import weka.core.Instances;

public class InstancesHeaderRow
extends HeaderRow {
    private static final long serialVersionUID = 5290309704559917874L;
    protected Instances m_Data;

    public InstancesHeaderRow(InstancesView owner) {
        super((SpreadSheet)owner);
        this.m_Data = owner.getData();
    }

    public Instances getData() {
        return this.m_Data;
    }

    protected int cellKeyToIndex(String cellKey) {
        if (Utils.isInteger((String)cellKey)) {
            return Integer.parseInt(cellKey);
        }
        return -1;
    }

    public void setOwner(SpreadSheet owner) {
        if (!(owner instanceof InstancesView)) {
            throw new IllegalArgumentException("Owner can only be " + InstancesView.class.getName());
        }
        super.setOwner(owner);
    }

    public HeaderRow getClone(SpreadSheet owner) {
        if (owner instanceof InstancesView) {
            return new InstancesHeaderRow((InstancesView)owner);
        }
        throw new IllegalArgumentException("Owner can only be " + InstancesView.class.getName());
    }

    public void clear() {
    }

    public void assign(Row row) {
    }

    public Cell newCell(Row owner) {
        return null;
    }

    public boolean hasCell(int columnIndex) {
        return this.getCell(columnIndex) != null;
    }

    public boolean hasCell(String cellKey) {
        return this.getCell(cellKey) != null;
    }

    public Cell addCell(int columnIndex) {
        return this.getCell(columnIndex);
    }

    public Cell addCell(String cellKey) {
        int col = this.cellKeyToIndex(cellKey);
        if (col >= 0 && col < this.getCellCount()) {
            return this.getCell(col);
        }
        return null;
    }

    public Cell removeCell(int columnIndex) {
        return null;
    }

    public Cell removeCell(String cellKey) {
        return null;
    }

    public Cell getCell(String cellKey) {
        return this.getCell(this.cellKeyToIndex(cellKey));
    }

    public Cell getCell(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getCellCount()) {
            return new DoubleCell((Row)this).setContentAsString(this.m_Data.attribute(columnIndex).name());
        }
        return null;
    }

    public String getContent(int columnIndex) {
        return this.getCell(columnIndex).getContent();
    }

    public String getCellKey(int columnIndex) {
        return "" + columnIndex;
    }

    public Collection<String> cellKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getCellCount(); ++i) {
            result.add("" + i);
        }
        return result;
    }

    public Collection<Cell> cells() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (int i = 0; i < this.getCellCount(); ++i) {
            result.add(this.getCell(i));
        }
        return result;
    }

    public int getCellCount() {
        return this.m_Data.numAttributes();
    }

    public boolean removeMissing() {
        return false;
    }

    public int indexOf(Cell cell) {
        if (cell.getOwner() instanceof InstancesHeaderRow) {
            if ((InstancesHeaderRow)cell.getOwner() == this) {
                return cell.index();
            }
            return -1;
        }
        return -1;
    }

    public void mergeWith(Row other) {
        throw new NotImplementedException();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.m_Data.attribute(i).name());
        }
        return result.toString();
    }
}

