/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.cso;

import adams.core.io.PlaceholderDirectory;
import adams.event.CatSwarmOptimizationFitnessChangeEvent;
import adams.event.CatSwarmOptimizationFitnessChangeNotifier;
import adams.opt.cso.AbstractSimpleCatSwarmOptimization;
import adams.opt.cso.CatSwarmOptimization;
import adams.opt.cso.ClassifierBasedCatSwarmOptimization;
import adams.opt.cso.Measure;
import adams.opt.cso.OutputPrefixType;
import adams.opt.cso.OutputType;
import java.util.Hashtable;
import java.util.Random;
import org.jblas.DoubleMatrix;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;

public abstract class AbstractClassifierBasedSimpleCatSwarmOptimization
extends AbstractSimpleCatSwarmOptimization
implements ClassifierBasedCatSwarmOptimization,
CatSwarmOptimizationFitnessChangeNotifier {
    private static final long serialVersionUID = -3893761358634772738L;
    protected Instances m_Instances;
    protected Classifier m_Classifier;
    protected int m_Folds;
    protected int m_CrossValidationSeed;
    protected Measure m_Measure;
    protected PlaceholderDirectory m_OutputDirectory;
    protected OutputType m_OutputType;
    protected OutputPrefixType m_OutputPrefixType;
    protected String m_SuppliedPrefix;
    public Hashtable<DoubleMatrix, Double> m_StoredResults = new Hashtable();

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("cv-seed", "crossValidationSeed", (Object)55);
        this.m_OptionManager.add("classifier", "classifier", (Object)this.getDefaultClassifier());
        this.m_OptionManager.add("measure", "measure", (Object)Measure.RMSE);
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("output-type", "outputType", (Object)this.getDefaultOutputType());
        this.m_OptionManager.add("output-prefix-type", "outputPrefixType", (Object)OutputPrefixType.NONE);
        this.m_OptionManager.add("supplied-prefix", "suppliedPrefix", (Object)"");
    }

    @Override
    public void setInstances(Instances value) {
        this.m_Instances = value;
    }

    @Override
    public Instances getInstances() {
        return this.m_Instances;
    }

    @Override
    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    @Override
    public int getFolds() {
        return this.m_Folds;
    }

    @Override
    public String foldsTipText() {
        return "The number of folds to use in cross-validation.";
    }

    @Override
    public void setCrossValidationSeed(int value) {
        this.m_CrossValidationSeed = value;
        this.reset();
    }

    @Override
    public int getCrossValidationSeed() {
        return this.m_CrossValidationSeed;
    }

    @Override
    public String crossValidationSeedTipText() {
        return "The seed value for cross-validation.";
    }

    protected Classifier getDefaultClassifier() {
        return new ZeroR();
    }

    @Override
    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    @Override
    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    @Override
    public String classifierTipText() {
        return "The classifier to use.";
    }

    @Override
    public void setMeasure(Measure value) {
        this.m_Measure = value;
        this.reset();
    }

    @Override
    public Measure getMeasure() {
        return this.m_Measure;
    }

    @Override
    public String measureTipText() {
        return "The measure used for evaluating the fitness.";
    }

    @Override
    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    @Override
    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    @Override
    public String outputDirectoryTipText() {
        return "The directory for storing the generated ARFF files.";
    }

    protected abstract OutputType getDefaultOutputType();

    @Override
    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    @Override
    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    @Override
    public String outputTypeTipText() {
        return "The type of output to generate.";
    }

    @Override
    public void setOutputPrefixType(OutputPrefixType value) {
        this.m_OutputPrefixType = value;
        this.reset();
    }

    @Override
    public OutputPrefixType getOutputPrefixType() {
        return this.m_OutputPrefixType;
    }

    @Override
    public String outputPrefixTypeTipText() {
        return "The type of prefix to use for the output.";
    }

    @Override
    public void setSuppliedPrefix(String value) {
        this.m_SuppliedPrefix = value;
        this.reset();
    }

    @Override
    public String getSuppliedPrefix() {
        return this.m_SuppliedPrefix;
    }

    @Override
    public String suppliedPrefixTipText() {
        return "The prefix to use in case of " + (Object)((Object)OutputPrefixType.SUPPLIED) + ".";
    }

    protected synchronized void addResult(DoubleMatrix key, Double val) {
        this.m_StoredResults.put(key, val);
    }

    protected synchronized Double getResult(DoubleMatrix key) {
        return this.m_StoredResults.get(key);
    }

    protected synchronized void clearResults() {
        this.m_StoredResults.clear();
    }

    public double getCurrentFitness() {
        return this.m_Measure.actual(this.m_LastFitness);
    }

    protected void fitnessChanged(double oldFitness, double newFitness) {
        oldFitness = this.m_Measure.actual(oldFitness);
        newFitness = this.m_Measure.actual(newFitness);
        this.getLogger().info("Fitness improvement: " + oldFitness + " -> " + newFitness);
        this.notifyFitnessChangeListeners(new CatSwarmOptimizationFitnessChangeEvent((CatSwarmOptimization)this, newFitness, (Object)this.getBestSetup()));
    }

    protected double evaluateClassifier(Classifier cls, Instances data, int folds, int seed) throws Exception {
        Evaluation evaluation = new Evaluation(data);
        evaluation.crossValidateModel(cls, data, folds, new Random(seed), new Object[0]);
        return this.getMeasure().extract(evaluation, true);
    }

    protected void preRun() {
        super.preRun();
        this.clearResults();
    }
}

