/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.cso;

import adams.core.base.BaseClassname;
import adams.core.discovery.AbstractDiscoveryHandler;
import adams.core.discovery.DefaultPropertyDiscovery;
import adams.core.discovery.PropertyPath;
import adams.core.discovery.cso.AbstractCatSwarmOptimizationDiscoveryHandler;
import adams.core.discovery.cso.GenericDouble;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.opt.cso.AbstractClassifierBasedSimpleCatSwarmOptimization;
import adams.opt.cso.Measure;
import adams.opt.cso.OutputType;
import adams.opt.cso.stopping.AbstractStoppingCriterion;
import adams.opt.cso.stopping.MaxIterationsWithoutImprovement;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.logging.Level;
import org.jblas.DoubleMatrix;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegressionJ;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.converters.ConverterUtils;

public class HermioneSimple
extends AbstractClassifierBasedSimpleCatSwarmOptimization {
    private static final long serialVersionUID = -6038649991364374788L;
    protected AbstractCatSwarmOptimizationDiscoveryHandler[] m_Handlers;

    public String globalInfo() {
        return "Simple swarm-based Hermione.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handlers", (Object)new AbstractCatSwarmOptimizationDiscoveryHandler[0]);
    }

    @Override
    protected OutputType getDefaultOutputType() {
        return OutputType.SETUP;
    }

    public void setHandlers(AbstractCatSwarmOptimizationDiscoveryHandler[] value) {
        this.m_Handlers = value;
        this.reset();
    }

    public AbstractCatSwarmOptimizationDiscoveryHandler[] getHandlers() {
        return this.m_Handlers;
    }

    public String handlersTipText() {
        return "The discovery handlers to use.";
    }

    public Classifier generateClassifier(DoubleMatrix particle) {
        int i;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("[generateClassifier] Particle: " + particle);
        }
        AbstractCatSwarmOptimizationDiscoveryHandler[] handlers = new AbstractCatSwarmOptimizationDiscoveryHandler[this.m_Handlers.length];
        for (i = 0; i < handlers.length; ++i) {
            handlers[i] = (AbstractCatSwarmOptimizationDiscoveryHandler)this.m_Handlers[i].shallowCopy();
        }
        Classifier result = (Classifier)OptionUtils.shallowCopy((Object)this.getClassifier());
        if (result == null) {
            this.getLogger().severe("Failed to copy classifier!");
            return null;
        }
        DefaultPropertyDiscovery discovery = new DefaultPropertyDiscovery();
        discovery.discover((AbstractDiscoveryHandler[])handlers, (Object)result);
        int pos = 0;
        for (AbstractCatSwarmOptimizationDiscoveryHandler handler : handlers) {
            int dimensions = handler.getDimensions();
            for (PropertyPath.PropertyContainer cont : handler.getContainers()) {
                double[] values = new double[dimensions];
                for (i = 0; i < dimensions; ++i) {
                    values[i] = particle.get(0, pos + i);
                }
                handler.apply(cont, values);
                pos += dimensions;
            }
        }
        return result;
    }

    public double particleFitness(DoubleMatrix particle) {
        Double result = this.getResult(particle);
        if (result != null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Already present: " + result);
            }
            return result;
        }
        Classifier cls = this.generateClassifier(particle);
        if (cls == null) {
            return Double.NaN;
        }
        try {
            result = this.evaluateClassifier(cls, this.m_Instances, this.m_Folds, this.m_CrossValidationSeed);
            this.addResult(particle, result);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to evaluate classifier!", (Throwable)e);
            result = Double.NaN;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("[particleFitness] fitness=" + result + " from " + particle);
        }
        return result;
    }

    public DoubleMatrix randomParticle() {
        int i;
        AbstractCatSwarmOptimizationDiscoveryHandler[] handlers = new AbstractCatSwarmOptimizationDiscoveryHandler[this.m_Handlers.length];
        for (i = 0; i < handlers.length; ++i) {
            handlers[i] = (AbstractCatSwarmOptimizationDiscoveryHandler)this.m_Handlers[i].shallowCopy();
            handlers[i].setSeed((long)this.m_Random.nextInt());
        }
        Classifier cls = (Classifier)OptionUtils.shallowCopy((Object)this.getClassifier());
        if (cls == null) {
            this.getLogger().severe("Failed to copy classifier!");
            return null;
        }
        DefaultPropertyDiscovery discovery = new DefaultPropertyDiscovery();
        discovery.discover((AbstractDiscoveryHandler[])handlers, (Object)cls);
        TDoubleArrayList collected = new TDoubleArrayList();
        for (AbstractCatSwarmOptimizationDiscoveryHandler handler : handlers) {
            for (PropertyPath.PropertyContainer cont : handler.getContainers()) {
                double[] values = handler.random();
                collected.add(values);
            }
        }
        DoubleMatrix result = new DoubleMatrix(1, collected.size());
        for (i = 0; i < collected.size(); ++i) {
            result.data[i] = collected.get(i);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("[randomParticle] " + result);
        }
        return result;
    }

    @Override
    public Classifier getBestSetup() {
        return this.generateClassifier(this.getBest());
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        Instances data = ConverterUtils.DataSource.read((String)args[0]);
        if (data.classIndex() == -1) {
            data.setClassIndex(data.numAttributes() - 1);
        }
        MaxIterationsWithoutImprovement stopping = new MaxIterationsWithoutImprovement();
        stopping.setNumIterations(2);
        stopping.setMinimumImprovement(0.001);
        stopping.setLoggingLevel(LoggingLevel.INFO);
        HermioneSimple simple = new HermioneSimple();
        simple.setEvalParallel(true);
        simple.setMeasure(Measure.CC);
        simple.setStopping((AbstractStoppingCriterion)stopping);
        simple.setLoggingLevel(LoggingLevel.INFO);
        simple.setInstances(data);
        LinearRegressionJ cls = new LinearRegressionJ();
        cls.setEliminateColinearAttributes(false);
        cls.setAttributeSelectionMethod(new SelectedTag(1, LinearRegressionJ.TAGS_SELECTION));
        simple.setClassifier((Classifier)new LinearRegressionJ());
        GenericDouble ridge = new GenericDouble();
        ridge.setClassname(new BaseClassname(((Object)((Object)cls)).getClass()));
        ridge.setProperty("ridge");
        ridge.setMinimum(1.0E-8);
        ridge.setMaximum(1.0);
        simple.setHandlers(new AbstractCatSwarmOptimizationDiscoveryHandler[]{ridge});
        DoubleMatrix best = simple.run();
        System.out.println(best);
    }
}

