/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.cso;

import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.core.UnassignedClassException;

public enum Measure {
    CC(false, true),
    RMSE(true, true),
    RRSE(true, true),
    MAE(true, true),
    RAE(true, true),
    ACC(true, false);

    private boolean m_Nominal;
    private boolean m_Numeric;

    private Measure(boolean nominal, boolean numeric) {
        this.m_Nominal = nominal;
        this.m_Numeric = numeric;
    }

    public double extract(Evaluation evaluation, boolean adjust) throws Exception {
        switch (this) {
            case ACC: {
                if (adjust) {
                    return 100.0 - evaluation.pctCorrect();
                }
                return evaluation.pctCorrect();
            }
            case CC: {
                if (adjust) {
                    return 1.0 - evaluation.correlationCoefficient();
                }
                return evaluation.correlationCoefficient();
            }
            case MAE: {
                return evaluation.meanAbsoluteError();
            }
            case RAE: {
                return evaluation.relativeAbsoluteError();
            }
            case RMSE: {
                return evaluation.rootMeanSquaredError();
            }
            case RRSE: {
                return evaluation.rootRelativeSquaredError();
            }
        }
        throw new IllegalStateException("Unhandled measure '" + (Object)((Object)this) + "'!");
    }

    public double actual(double value) {
        switch (this) {
            case ACC: {
                return 100.0 - value;
            }
            case CC: {
                return 1.0 - value;
            }
            case MAE: 
            case RAE: 
            case RMSE: 
            case RRSE: {
                return value;
            }
        }
        throw new IllegalStateException("Unhandled measure '" + (Object)((Object)this) + "'!");
    }

    public boolean isValid(Instances data) {
        if (data.classIndex() == -1) {
            throw new UnassignedClassException("No class attribute set!");
        }
        if (data.classAttribute().isNominal()) {
            return this.m_Nominal;
        }
        if (data.classAttribute().isNumeric()) {
            return this.m_Numeric;
        }
        throw new IllegalStateException("Class attribute '" + data.classAttribute().type() + "' not handled!");
    }
}

