/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.genetic;

import adams.opt.genetic.AbstractClassifierBasedGeneticAlgorithm;
import java.util.Hashtable;
import weka.core.Instances;

public abstract class AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation
extends AbstractClassifierBasedGeneticAlgorithm {
    private static final long serialVersionUID = -7323960806463832596L;
    protected boolean m_UseSecondEvaluation;
    protected int m_SecondFolds;
    protected int m_SecondCrossValidationSeed;
    public Hashtable<String, Double> m_SecondStoredResults = new Hashtable();
    protected double m_SecondBestFitness;
    protected Object m_SecondBestSetup;
    protected int[] m_SecondBestWeights;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-second-evaluation", "useSecondEvaluation", (Object)false);
        this.m_OptionManager.add("second-folds", "secondFolds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("second-cv-seed", "secondCrossValidationSeed", (Object)42);
    }

    protected void initialize() {
        super.initialize();
        this.m_SecondBestFitness = Double.NEGATIVE_INFINITY;
        this.m_SecondBestSetup = null;
        this.m_SecondBestWeights = null;
    }

    public void setUseSecondEvaluation(boolean value) {
        this.m_UseSecondEvaluation = value;
        this.reset();
    }

    public boolean getUseSecondEvaluation() {
        return this.m_UseSecondEvaluation;
    }

    public String useSecondEvaluationTipText() {
        return "If enabled, a second evaluation is performed using the separate folds and seed.";
    }

    public void setSecondFolds(int value) {
        this.m_SecondFolds = value;
        this.reset();
    }

    public int getSecondFolds() {
        return this.m_SecondFolds;
    }

    public String secondFoldsTipText() {
        return "The number of folds to use in cross-validation (second evaluation).";
    }

    public void setSecondCrossValidationSeed(int value) {
        this.m_SecondCrossValidationSeed = value;
        this.reset();
    }

    public int getSecondCrossValidationSeed() {
        return this.m_SecondCrossValidationSeed;
    }

    public String secondCrossValidationSeedTipText() {
        return "The seed value for cross-validation (second evaluation).";
    }

    protected synchronized void addSecondResult(String key, Double val) {
        this.m_SecondStoredResults.put(key, val);
    }

    protected synchronized Double getSecondResult(String key) {
        return this.m_SecondStoredResults.get(key);
    }

    @Override
    protected synchronized void clearResults() {
        super.clearResults();
        this.m_SecondStoredResults.clear();
    }

    public synchronized boolean isSecondBetterFitness(double fitness) {
        return fitness > this.m_SecondBestFitness;
    }

    public synchronized boolean setSecondNewFitness(double fitness, Object setup, int chromosome, int[] weights) {
        boolean result = false;
        if (this.isSecondBetterFitness(fitness)) {
            this.m_SecondBestFitness = fitness;
            this.m_SecondBestSetup = setup;
            this.m_SecondBestWeights = (int[])weights.clone();
            result = true;
        }
        return result;
    }

    @Override
    protected void preRun() {
        super.preRun();
        this.m_SecondBestFitness = Double.NEGATIVE_INFINITY;
        this.m_SecondBestSetup = null;
        this.m_SecondBestWeights = null;
    }

    public static abstract class ClassifierBasedGeneticAlgorithmWithSecondEvaluationJob<T extends AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation>
    extends AbstractClassifierBasedGeneticAlgorithm.ClassifierBasedGeneticAlgorithmJob<T> {
        private static final long serialVersionUID = 5294683216617538910L;
        protected boolean m_UseSecondEvaluation;
        protected Double m_SecondFitness;
        protected int m_SecondSeed;
        protected int m_SecondFolds;

        public ClassifierBasedGeneticAlgorithmWithSecondEvaluationJob(T g, int chromosome, int[] w, Instances data) {
            super(g, chromosome, w, data);
            this.m_UseSecondEvaluation = ((AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation)((Object)g)).getUseSecondEvaluation();
            this.m_SecondFolds = ((AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation)((Object)g)).getSecondFolds();
            this.m_SecondSeed = ((AbstractClassifierBasedGeneticAlgorithmWithSecondEvaluation)((Object)g)).getSecondCrossValidationSeed();
            this.m_SecondFitness = null;
        }

        public boolean getUseSecondEvaluation() {
            return this.m_UseSecondEvaluation;
        }

        public int getSecondSeed() {
            return this.m_SecondSeed;
        }

        public int getSecondFolds() {
            return this.m_SecondFolds;
        }

        public Double getSecondFitness() {
            return this.m_SecondFitness;
        }
    }
}

