/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.genetic;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.opt.genetic.AbstractClassifierBasedGeneticAlgorithm;
import adams.opt.genetic.AbstractGeneticAlgorithm;
import adams.opt.genetic.OutputType;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.attribute.Remove;

public class DarkLord
extends AbstractClassifierBasedGeneticAlgorithm {
    private static final long serialVersionUID = 4822397823362084867L;

    public String globalInfo() {
        return "The Dark Lord.";
    }

    @Override
    protected OutputType getDefaultOutputType() {
        return OutputType.ALL;
    }

    @Override
    protected DarkLordJob newJob(int chromosome, int[] w, Instances data) {
        return new DarkLordJob(this, chromosome, w, data);
    }

    @Override
    protected Properties storeSetup(Instances data, AbstractGeneticAlgorithm.GeneticAlgorithmJob job) {
        Properties result = super.storeSetup(data, job);
        DarkLordJob jobDL = (DarkLordJob)job;
        result.setProperty("mask", jobDL.getMaskAsString());
        Remove remove = new Remove();
        remove.setAttributeIndices(jobDL.getRemoveAsString());
        remove.setInvertSelection(true);
        result.setProperty("filter", OptionUtils.getCommandLine((Object)remove));
        return result;
    }

    @Override
    protected void preRun() {
        super.preRun();
        this.init(20, this.m_Instances.numAttributes() * this.m_BitsPerGene);
    }

    public static class DarkLordJob
    extends AbstractClassifierBasedGeneticAlgorithm.ClassifierBasedGeneticAlgorithmJob<DarkLord> {
        private static final long serialVersionUID = 8259167463381721274L;

        public DarkLordJob(DarkLord g, int num, int[] w, Instances data) {
            super(g, num, w, data);
        }

        public String getMaskAsString() {
            String ret = "[";
            int pos = 0;
            int last = -1;
            boolean thefirst = true;
            for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                if (a == this.getInstances().classIndex()) continue;
                if (this.m_Weights[a] == 0) {
                    if (last == -1) continue;
                    if (thefirst) {
                        thefirst = false;
                    } else {
                        ret = String.valueOf(ret) + ",";
                    }
                    ret = pos - last > 1 ? String.valueOf(ret) + last + "-" + pos : (pos - last == 1 ? String.valueOf(ret) + last + "," + pos : String.valueOf(ret) + last);
                    last = -1;
                }
                if (this.m_Weights[a] == 0) continue;
                if (last == -1) {
                    last = a;
                }
                pos = a;
            }
            if (last != -1) {
                if (!thefirst) {
                    ret = String.valueOf(ret) + ",";
                }
                ret = pos - last > 1 ? String.valueOf(ret) + last + "-" + pos : (pos - last == 1 ? String.valueOf(ret) + last + "," + pos : String.valueOf(ret) + last);
            }
            return String.valueOf(ret) + "]";
        }

        public String getRemoveAsString() {
            String ret = "";
            int pos = 0;
            int last = -1;
            boolean thefirst = true;
            for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                if (this.m_Weights[a] == 0 && a != this.getInstances().classIndex()) {
                    if (last == -1) continue;
                    if (thefirst) {
                        thefirst = false;
                    } else {
                        ret = String.valueOf(ret) + ",";
                    }
                    ret = pos - last > 1 ? String.valueOf(ret) + (last + 1) + "-" + (pos + 1) : (pos - last == 1 ? String.valueOf(ret) + (last + 1) + "," + (pos + 1) : String.valueOf(ret) + (last + 1));
                    last = -1;
                }
                if (this.m_Weights[a] == 0 && a != this.getInstances().classIndex()) continue;
                if (last == -1) {
                    last = a;
                }
                pos = a;
            }
            if (last != -1) {
                if (!thefirst) {
                    ret = String.valueOf(ret) + ",";
                }
                ret = pos - last > 1 ? String.valueOf(ret) + (last + 1) + "-" + (pos + 1) : (pos - last == 1 ? String.valueOf(ret) + (last + 1) + "," + (pos + 1) : String.valueOf(ret) + (last + 1));
            }
            return ret;
        }

        @Override
        protected Properties assembleSetup(double fitness, Classifier cls, int chromosome, int[] weights) {
            Properties result = super.assembleSetup(fitness, cls, chromosome, weights);
            result.setProperty("Mask", this.getMaskAsString());
            return result;
        }

        public void calcNewFitness() {
            try {
                this.getLogger().fine("calc for:" + this.weightsToString());
                Double cc = ((DarkLord)this.getOwner()).getResult(this.weightsToString());
                if (cc != null) {
                    this.getLogger().info("Already present: " + Double.toString(cc));
                    this.m_Fitness = cc;
                    return;
                }
                Instances newInstances = new Instances(this.getInstances());
                for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                    Instance in = newInstances.instance(i);
                    int cnt = 0;
                    for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                        if (a == this.getInstances().classIndex()) continue;
                        if (this.m_Weights[cnt++] == 0) {
                            in.setValue(a, 0.0);
                            continue;
                        }
                        in.setValue(a, in.value(a));
                    }
                }
                Classifier newClassifier = (Classifier)OptionUtils.shallowCopy((Object)((DarkLord)this.getOwner()).getClassifier());
                this.m_Fitness = this.evaluateClassifier(newClassifier, newInstances, this.getFolds(), this.getSeed());
                if (((DarkLord)this.getOwner()).setNewFitness(this.m_Fitness, newClassifier, this.m_Chromosome, this.m_Weights)) {
                    this.generateOutput(this.m_Fitness, newInstances, newClassifier, this.m_Chromosome, this.m_Weights);
                    ((DarkLord)this.getOwner()).notifyFitnessChangeListeners(this.getMeasure().adjust(this.m_Fitness), newClassifier, this.m_Weights);
                } else {
                    this.getLogger().fine(this.getMaskAsString());
                }
                ((DarkLord)this.getOwner()).addResult(this.weightsToString(), this.m_Fitness);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error: ", (Throwable)e);
                this.m_Fitness = null;
            }
        }
    }
}

