/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.data.weka.InstancesViewSupporter;
import adams.flow.container.WekaTrainTestSetContainer;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import weka.core.Instances;

public abstract class AbstractSplitGenerator
implements Serializable,
Iterator<WekaTrainTestSetContainer>,
InstancesViewSupporter {
    private static final long serialVersionUID = -8387205583429213079L;
    protected long m_Seed;
    protected boolean m_UseViews;
    protected Random m_Random;
    protected Instances m_Data;
    protected boolean m_Initialized;
    protected TIntList m_OriginalIndices;

    public AbstractSplitGenerator(Instances data, long seed) {
        if (data == null) {
            throw new IllegalArgumentException("No data provided!");
        }
        this.m_Data = new Instances(data);
        this.m_Seed = seed;
        this.m_Initialized = false;
        this.m_OriginalIndices = new TIntArrayList();
    }

    public Instances getData() {
        return this.m_Data;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    @Override
    public void setUseViews(boolean value) {
        this.m_UseViews = value;
        this.m_Initialized = false;
    }

    @Override
    public boolean getUseViews() {
        return this.m_UseViews;
    }

    protected abstract boolean canRandomize();

    protected abstract boolean checkNext();

    @Override
    public synchronized boolean hasNext() {
        return this.checkNext();
    }

    protected void randomize(TIntList indices, Random random) {
        for (int j = indices.size() - 1; j > 0; --j) {
            int i = random.nextInt(j + 1);
            int val = indices.get(j);
            indices.set(j, indices.get(i));
            indices.set(i, val);
        }
    }

    protected TIntList originalIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.m_Data.numInstances(); ++i) {
            result.add(i);
        }
        if (this.canRandomize()) {
            this.randomize((TIntList)result, new Random(this.m_Seed));
        }
        return result;
    }

    protected void initialize() {
        this.m_Initialized = true;
        this.m_OriginalIndices = this.originalIndices();
        if (this.canRandomize()) {
            this.m_Random = new Random(this.m_Seed);
            if (!this.m_UseViews) {
                this.m_Data.randomize(this.m_Random);
            }
        }
    }

    protected abstract WekaTrainTestSetContainer createNext();

    @Override
    public synchronized WekaTrainTestSetContainer next() {
        if (!this.m_Initialized) {
            this.initialize();
        }
        return this.createNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not implemented!");
    }

    public String toString() {
        return "data=" + this.m_Data.relationName() + (this.canRandomize() ? ", seed=" + this.m_Seed : "");
    }
}

