/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class CrossValidationHelper {
    public static int[] crossValidationIndices(Instances data, int folds, Random random) {
        return CrossValidationHelper.crossValidationIndices(data, folds, random, true);
    }

    public static int[] crossValidationIndices(Instances data, int folds, Random random, boolean stratify) {
        int i;
        TIntArrayList result = new TIntArrayList();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("Index"));
        atts.add((Attribute)data.classAttribute().copy());
        Instances dataWithIndices = new Instances("data with indices", atts, data.numInstances());
        dataWithIndices.setClassIndex(1);
        for (i = 0; i < data.numInstances(); ++i) {
            double[] values = new double[]{i, data.instance(i).classValue()};
            DenseInstance inst = new DenseInstance(1.0, values);
            dataWithIndices.add((Instance)inst);
        }
        dataWithIndices = new Instances(dataWithIndices);
        dataWithIndices.randomize(random);
        if (stratify && dataWithIndices.classAttribute().isNominal()) {
            dataWithIndices.stratify(folds);
        }
        for (i = 0; i < folds; ++i) {
            Instances train = dataWithIndices.trainCV(folds, i, random);
            Instances test = dataWithIndices.testCV(folds, i);
            for (int n = 0; n < test.numInstances(); ++n) {
                result.add((int)test.instance(n).value(0));
            }
        }
        return result.toArray();
    }

    public static int[] alignIndices(int[] original) {
        int[] result = new int[original.length];
        for (int i = 0; i < original.length; ++i) {
            result[original[i]] = i;
        }
        return result;
    }

    public static ArrayList<Prediction> alignPredictions(ArrayList<Prediction> predictions, int[] original) {
        ArrayList<Prediction> result = new ArrayList<Prediction>();
        int[] aligned = CrossValidationHelper.alignIndices(original);
        for (int i = 0; i < aligned.length; ++i) {
            result.add(predictions.get(aligned[i]));
        }
        return result;
    }
}

