/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.flow.container.WekaTrainTestSetContainer;
import weka.classifiers.AbstractSplitGenerator;
import weka.core.Instances;
import weka.core.InstancesView;

public class RandomSplitGenerator
extends AbstractSplitGenerator {
    private static final long serialVersionUID = -4813006743965500489L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;
    protected boolean m_Generated;

    public RandomSplitGenerator(Instances data, long seed, double percentage) {
        super(data, seed);
        if (percentage <= 0.0 || percentage >= 1.0) {
            throw new IllegalArgumentException("Percentage must satisfy 0 < x < 1, provided: " + percentage);
        }
        this.m_Percentage = percentage;
        this.m_PreserveOrder = false;
    }

    public RandomSplitGenerator(Instances data, double percentage) {
        super(data, -1L);
        if (percentage <= 0.0 || percentage >= 1.0) {
            throw new IllegalArgumentException("Percentage must satisfy 0 < x < 1, provided: " + percentage);
        }
        this.m_Percentage = percentage;
        this.m_PreserveOrder = true;
    }

    @Override
    protected boolean canRandomize() {
        return !this.m_PreserveOrder;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Generated = false;
    }

    @Override
    protected boolean checkNext() {
        return !this.m_Generated;
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        InstancesView testSet;
        InstancesView trainSet;
        this.m_Generated = true;
        int trainSize = (int)Math.round((double)this.m_Data.numInstances() * this.m_Percentage);
        int testSize = this.m_Data.numInstances() - trainSize;
        int[] trainRows = this.m_OriginalIndices.subList(0, trainSize).toArray();
        int[] testRows = this.m_OriginalIndices.subList(trainSize, this.m_OriginalIndices.size()).toArray();
        if (this.m_UseViews) {
            trainSet = new InstancesView(this.m_Data, trainRows);
            testSet = new InstancesView(this.m_Data, testRows);
        } else {
            trainSet = new Instances(this.m_Data, 0, trainSize);
            testSet = new Instances(this.m_Data, trainSize, testSize);
        }
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(trainSet, testSet, this.m_Seed, null, null, trainRows, testRows);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", percentage=" + this.m_Percentage;
    }
}

