/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import adams.core.option.OptionUtils;
import adams.opt.genetic.AbstractClassifierBasedGeneticAlgorithm;
import adams.opt.genetic.Hermione;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class GeneticAlgorithm
extends AbstractClassifier {
    private static final long serialVersionUID = 8430850643799590721L;
    protected AbstractClassifierBasedGeneticAlgorithm m_Algorithm = new Hermione();
    protected Classifier m_Model = null;

    public String globalInfo() {
        return "Applies the specified genetic algorithm to the training data and uses the best setup for the final model.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe genetic algorithm.\n\t(default: " + Hermione.class.getName() + ")", "algorithm", 1, "-algorithm <classname + options>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-algorithm");
        result.add(OptionUtils.getCommandLine((Object)((Object)this.m_Algorithm)));
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"algorithm", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAlgorithm((AbstractClassifierBasedGeneticAlgorithm)((Object)OptionUtils.forAnyCommandLine(AbstractClassifierBasedGeneticAlgorithm.class, (String)tmpStr)));
        } else {
            this.setAlgorithm(new Hermione());
        }
        super.setOptions(options);
    }

    public void setAlgorithm(AbstractClassifierBasedGeneticAlgorithm value) {
        this.m_Algorithm = value;
    }

    public AbstractClassifierBasedGeneticAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The genetic algorithm to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.assign(this.m_Algorithm.getClassifier().getCapabilities());
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.m_Algorithm.setInstances(data);
        this.m_Algorithm.run();
        this.m_Model = (Classifier)this.m_Algorithm.getCurrentSetup();
        this.m_Model.buildClassifier(data);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_Model == null) {
            throw new IllegalStateException("No model built!");
        }
        return this.m_Model.classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Model == null) {
            throw new IllegalStateException("No model built!");
        }
        return this.m_Model.distributionForInstance(instance);
    }

    public String getRevision() {
        return "$Revision: 14402 $";
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.m_Model == null) {
            result.append("No model built yet");
        } else {
            result.append("Genetic algorithm: ").append(OptionUtils.getCommandLine((Object)((Object)this.m_Algorithm))).append("\n").append("Best setup: ").append(OptionUtils.getCommandLine((Object)this.m_Model)).append("\n").append(this.m_Model.toString());
        }
        return result.toString();
    }

    public static void main(String[] args) {
        GeneticAlgorithm.runClassifier((Classifier)new GeneticAlgorithm(), (String[])args);
    }
}

