/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.ParallelMultipleClassifiersCombiner;
import weka.classifiers.trees.M5P;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class PartitionedStacking
extends ParallelMultipleClassifiersCombiner {
    private static final long serialVersionUID = -8282901622586083613L;
    protected Classifier m_MetaLevelClassifier = new M5P();
    protected Range[] m_Ranges = new Range[]{new Range("first-last")};
    protected Remove[] m_Remove;
    protected Instances m_MetaLevelData;

    public String globalInfo() {
        return "Builds the base-classifiers on subsets of the data defined by ranges that correspond to the base-classifiers. The base-classifiers expect the class attribute to be the last attribute in the range of attributes that is defined for them.\nThe predictions of the base-classifiers and the original class attribute are used to generated a new meta-dataset that is used as input for the meta-level classifier.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe attributes ranges to use for training the base-classifiers.\n\tMust be specified as often as there are base-classifiers.\n\tThis is a comma separated list of attribute indices, with\n\t\"first\" and \"last\" valid values. Specify an inclusive \n\trange with \"-\". E.g: \"first-3,5,6-10,last\".", "R", 1, "-R <range>"));
        result.addElement(new Option("\tFull class name of the classifier to use for the meta-level,\n\tfollowed by scheme options.\n\t(default: \"" + M5P.class.getName() + "\")", "M", 1, "-M <classifier specification>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        Vector<Range> ranges = new Vector<Range>();
        while ((tmpStr = Utils.getOption((char)'R', (String[])options)).length() != 0) {
            ranges.add(new Range(tmpStr));
        }
        if (ranges.size() == 0) {
            ranges.add(new Range("first-last"));
        }
        this.setRanges(ranges.toArray(new Range[ranges.size()]));
        tmpStr = Utils.getOption((char)'M', (String[])options);
        if (tmpStr.length() != 0) {
            String[] clsOptions = Utils.splitOptions((String)tmpStr);
            String clsName = clsOptions[0];
            clsOptions[0] = "";
            this.setMetaLevelClassifier((Classifier)Utils.forName(Classifier.class, (String)clsName, (String[])clsOptions));
        } else {
            this.setMetaLevelClassifier((Classifier)new M5P());
        }
        super.setOptions(options);
        if (this.getClassifiers().length != this.getRanges().length) {
            throw new IllegalArgumentException("Number of base-classifiers and attribute ranges don't match: " + this.getClassifiers().length + " != " + this.getRanges().length);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        for (Range range : this.getRanges()) {
            result.add("-R");
            result.add(range.getRanges());
        }
        result.add("-M");
        result.add(Utils.toCommandLine((Object)this.getMetaLevelClassifier()));
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setRanges(Range[] value) {
        this.m_Ranges = value;
    }

    public Range[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The attribute ranges for base-classifiers.";
    }

    public void setMetaLevelClassifier(Classifier value) {
        this.m_MetaLevelClassifier = value;
    }

    public Classifier getMetaLevelClassifier() {
        return this.m_MetaLevelClassifier;
    }

    public String metaLevelClassifierTipText() {
        return "The meta-level classifier to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.and(this.m_MetaLevelClassifier.getCapabilities());
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected synchronized void buildClassifiers(final Instances data) throws Exception {
        this.m_Remove = new Remove[this.m_Classifiers.length];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            final Classifier currentClassifier = this.m_Classifiers[i];
            final int iteration = i;
            this.m_Ranges[i].setUpper(data.numAttributes() - 1);
            Runnable newTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        PartitionedStacking.this.m_Remove[iteration] = new Remove();
                        PartitionedStacking.this.m_Remove[iteration].setAttributeIndicesArray(PartitionedStacking.this.m_Ranges[iteration].getSelection());
                        PartitionedStacking.this.m_Remove[iteration].setInvertSelection(true);
                        PartitionedStacking.this.m_Remove[iteration].setInputFormat(data);
                        Instances newData = Filter.useFilter((Instances)data, (Filter)PartitionedStacking.this.m_Remove[iteration]);
                        if (PartitionedStacking.this.m_Debug) {
                            System.out.println("Training classifier (" + (iteration + 1) + ")");
                        }
                        currentClassifier.buildClassifier(newData);
                        if (PartitionedStacking.this.m_Debug) {
                            System.out.println("Finished classifier (" + (iteration + 1) + ")");
                        }
                        PartitionedStacking.this.completedClassifier(iteration, true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        PartitionedStacking.this.completedClassifier(iteration, false);
                    }
                }
            };
            this.m_executorPool.execute(newTask);
        }
        if (this.m_completed + this.m_failed < this.m_Classifiers.length) {
            this.block(true);
        }
    }

    public void buildClassifier(Instances data) throws Exception {
        int i;
        if (this.m_MetaLevelClassifier == null) {
            throw new IllegalArgumentException("No meta-level classifier has been set");
        }
        if (this.m_numExecutionSlots < 1) {
            throw new Exception("Number of execution slots needs to be >= 1!");
        }
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (this.m_Debug) {
            System.out.println("Starting executor pool with " + this.m_numExecutionSlots + " slot(s)...");
        }
        this.startExecutorPool();
        this.m_completed = 0;
        this.m_failed = 0;
        this.buildClassifiers(data);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < this.m_Ranges.length; ++i) {
            atts.add(new Attribute(this.m_Ranges[i].getRanges()));
        }
        atts.add((Attribute)data.classAttribute().copy());
        Instances metaData = new Instances(data.relationName() + "-meta", atts, data.numInstances());
        metaData.setClassIndex(metaData.numAttributes() - 1);
        for (i = 0; i < this.m_Ranges.length; ++i) {
            Instances subData = Filter.useFilter((Instances)data, (Filter)this.m_Remove[i]);
            for (int n = 0; n < subData.numInstances(); ++n) {
                metaData.add((Instance)new DenseInstance(metaData.numAttributes()));
                metaData.instance(n).setValue(i, this.m_Classifiers[i].classifyInstance(subData.instance(n)));
                metaData.instance(n).setClassValue(data.instance(n).classValue());
            }
        }
        this.m_MetaLevelClassifier.buildClassifier(metaData);
        this.m_MetaLevelData = new Instances(metaData, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double[] values = new double[this.m_MetaLevelData.numAttributes()];
        values[this.m_MetaLevelData.classIndex()] = Utils.missingValue();
        for (int i = 0; i < this.m_Ranges.length; ++i) {
            this.m_Remove[i].input(instance);
            this.m_Remove[i].batchFinished();
            Instance subInstance = this.m_Remove[i].output();
            values[i] = this.m_Classifiers[i].classifyInstance(subInstance);
        }
        DenseInstance metaInstance = new DenseInstance(instance.weight(), values);
        metaInstance.setDataset(this.m_MetaLevelData);
        return this.m_MetaLevelClassifier.classifyInstance((Instance)metaInstance);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }

    public static void main(String[] args) {
        PartitionedStacking.runClassifier((Classifier)new PartitionedStacking(), (String[])args);
    }
}

