/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.data.weka.WekaLabelIndex;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.meta.Vote;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ModelOutputHandler;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class Veto
extends MultipleClassifiersCombiner
implements ModelOutputHandler {
    private static final long serialVersionUID = 943666951855888860L;
    public static final String LABEL = "label";
    public static final String SUPPORT = "support";
    public static final String SUPPRESS_MODEL_OUTPUT = "suppress-model-output";
    protected WekaLabelIndex m_Label = new WekaLabelIndex("first");
    protected int m_ActualLabel;
    protected double m_Support = this.getDefaultSupport();
    protected int m_ActualSupport;
    protected Vote m_Vote = null;
    protected boolean m_SuppressModelOutput = false;

    public String globalInfo() {
        return "If the specified label is predicted by the required minimum number of classifiers of the ensemble, then this label is predicted. Otherwise, Vote with majority rule is used.";
    }

    protected WekaLabelIndex getDefaultLabel() {
        return new WekaLabelIndex("first");
    }

    public void setLabel(WekaLabelIndex value) {
        this.m_Label = value;
    }

    public WekaLabelIndex getLabel() {
        return this.m_Label;
    }

    public String labelTipText() {
        return "The index of the label to check.";
    }

    protected double getDefaultSupport() {
        return 1.0;
    }

    public void setSupport(double value) {
        if (value > 0.0) {
            this.m_Support = value;
        } else {
            System.err.println("Support must meet >0, provided: " + value);
        }
    }

    public double getSupport() {
        return this.m_Support;
    }

    public String supportTipText() {
        return "The percentage (0-1 excl) or number of base-classifiers (>= 1) that need to chose the label in order to predict it";
    }

    @Override
    public void setSuppressModelOutput(boolean value) {
        this.m_SuppressModelOutput = value;
    }

    @Override
    public boolean getSuppressModelOutput() {
        return this.m_SuppressModelOutput;
    }

    @Override
    public String suppressModelOutputTipText() {
        return "If enabled, suppresses any large model output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.labelTipText(), "" + this.getDefaultLabel().getIndex(), LABEL);
        WekaOptionUtils.addOption(result, this.supportTipText(), "" + this.getDefaultSupport(), SUPPORT);
        WekaOptionUtils.addFlag(result, this.suppressModelOutputTipText(), SUPPRESS_MODEL_OUTPUT);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setLabel(new WekaLabelIndex(WekaOptionUtils.parse(options, LABEL, this.getDefaultLabel().getIndex())));
        this.setSupport(WekaOptionUtils.parse(options, SUPPORT, this.getDefaultSupport()));
        this.setSuppressModelOutput(Utils.getFlag((String)SUPPRESS_MODEL_OUTPUT, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, LABEL, this.getLabel().getIndex());
        WekaOptionUtils.add(result, SUPPORT, this.getSupport());
        WekaOptionUtils.add(result, SUPPRESS_MODEL_OUTPUT, this.getSuppressModelOutput());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disable(Capabilities.Capability.DATE_CLASS);
        result.disable(Capabilities.Capability.NUMERIC_CLASS);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_ActualSupport = this.m_Support >= 1.0 ? (int)this.m_Support : (int)Math.round(this.m_Support * (double)this.m_Classifiers.length);
        if (this.getDebug()) {
            System.out.println("Actual support: " + this.m_ActualSupport);
        }
        this.m_Vote = new Vote();
        this.m_Vote.setCombinationRule(new SelectedTag(3, Vote.TAGS_RULES));
        this.m_Vote.setClassifiers(this.m_Classifiers);
        this.m_Vote.buildClassifier(data);
        this.m_Label.setData(data.classAttribute());
        this.m_ActualLabel = this.m_Label.getIntIndex();
        if (this.getDebug()) {
            System.out.println("Actual label index: " + this.m_ActualLabel);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        int support = 0;
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            int label = (int)this.m_Classifiers[i].classifyInstance(instance);
            if (label != this.m_ActualLabel) continue;
            ++support;
        }
        if (this.getDebug()) {
            System.out.println("support[" + support + "] >= act.support[" + this.m_ActualSupport + "]? " + (support >= this.m_ActualSupport));
        }
        if (support >= this.m_ActualSupport) {
            return this.m_ActualLabel;
        }
        return this.m_Vote.classifyInstance(instance);
    }

    public String toString() {
        if (this.m_Vote == null) {
            return "No model built yet";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n\n");
        result.append("Support: " + this.m_Support + "\n");
        result.append("Actual support: " + this.m_ActualSupport + "\n");
        result.append("Label: " + this.m_Label.getIndex() + "\n");
        result.append("Actual label index: " + this.m_ActualLabel + "\n");
        if (!this.m_SuppressModelOutput) {
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                result.append("\n");
                result.append("Classifier #" + (i + 1) + "\n");
                result.append(new String("Classifier #" + (i + 1)).replaceAll(".", "-") + "\n\n");
                result.append(this.m_Classifiers[i].toString());
            }
        }
        return result.toString();
    }
}

