/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import adams.core.exception.NotImplementedException;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WekaEnumeration;
import weka.experiment.Stats;

public class InstancesView
extends Instances {
    private static final long serialVersionUID = 6849032134927533467L;
    protected Instances m_Dataset;
    protected TIntList m_Rows;

    public InstancesView(Instances dataset, int[] rows) {
        super(new Instances(dataset, 0));
        this.m_Dataset = dataset;
        this.m_Rows = rows == null ? null : new TIntArrayList(rows);
    }

    public Instances stringFreeStructure() {
        return new InstancesView(this.m_Dataset.stringFreeStructure(), this.m_Rows == null ? null : this.m_Rows.toArray());
    }

    public boolean add(Instance instance) {
        this.m_Dataset.add(instance);
        if (this.m_Rows != null) {
            this.m_Rows.add(this.m_Dataset.numInstances() - 1);
        }
        return true;
    }

    public void add(int index, Instance instance) {
        throw new NotImplementedException();
    }

    public void compactify() {
    }

    public void delete() {
        this.m_Rows = null;
        this.m_Dataset.delete();
    }

    public void delete(int index) {
        if (this.m_Rows == null) {
            this.m_Dataset.delete(index);
        } else {
            this.m_Rows.removeAt(index);
        }
    }

    public void deleteAttributeAt(int position) {
        super.deleteAttributeAt(position);
        this.m_Dataset.deleteAttributeAt(position);
    }

    public void deleteAttributeType(int attType) {
        super.deleteAttributeAt(attType);
        this.m_Dataset.deleteAttributeType(attType);
    }

    public void deleteWithMissing(int attIndex) {
        if (this.m_Rows == null) {
            this.m_Dataset.deleteWithMissing(attIndex);
            return;
        }
        TIntArrayList newRows = new TIntArrayList();
        for (int i = 0; i < this.m_Rows.size(); ++i) {
            if (this.instance(this.m_Rows.get(i)).isMissing(attIndex)) continue;
            newRows.add(this.m_Rows.get(i));
        }
        this.m_Rows = newRows;
    }

    public Enumeration<Instance> enumerateInstances() {
        if (this.m_Rows == null) {
            return this.m_Dataset.enumerateInstances();
        }
        ArrayList<Instance> insts = new ArrayList<Instance>();
        for (int i = 0; i < this.numInstances(); ++i) {
            insts.add(this.instance(i));
        }
        return new WekaEnumeration(insts);
    }

    public Instance firstInstance() {
        return this.instance(0);
    }

    public void insertAttributeAt(Attribute att, int position) {
        super.insertAttributeAt(att, position);
        this.m_Dataset.insertAttributeAt(att, position);
    }

    public Instance instance(int index) {
        if (this.m_Rows == null) {
            return this.m_Dataset.instance(index);
        }
        return this.m_Dataset.instance(this.m_Rows.get(index));
    }

    public Instance get(int index) {
        return this.instance(index);
    }

    public Instance lastInstance() {
        return this.instance(this.numInstances() - 1);
    }

    public int numClasses() {
        if (!this.classAttribute().isNominal()) {
            return 1;
        }
        return this.classAttribute().numValues();
    }

    public int size() {
        return this.numInstances();
    }

    public int numInstances() {
        return this.m_Rows != null ? this.m_Rows.size() : this.m_Dataset.numInstances();
    }

    public void swap(int i, int j) {
        if (this.m_Rows == null) {
            this.m_Dataset.swap(i, j);
        } else {
            int old = this.m_Rows.get(i);
            this.m_Rows.set(i, this.m_Rows.get(j));
            this.m_Rows.set(j, old);
        }
    }

    public void replaceAttributeAt(Attribute att, int position) {
        super.replaceAttributeAt(att, position);
        this.m_Dataset.replaceAttributeAt(att, position);
    }

    public Instance remove(int index) {
        Instance result = this.instance(index);
        this.delete(index);
        return result;
    }

    public void renameAttribute(int att, String name) {
        super.renameAttribute(att, name);
        this.m_Dataset.renameAttribute(att, name);
    }

    public void renameAttributeValue(int att, int val, String name) {
        super.renameAttributeValue(att, val, name);
        this.m_Dataset.renameAttributeValue(att, val, name);
    }

    public Instance set(int index, Instance instance) {
        if (this.m_Rows == null) {
            return this.m_Dataset.set(index, instance);
        }
        return this.m_Dataset.set(this.m_Rows.get(index), instance);
    }

    protected void sortBasedOnNominalAttribute(int attIndex) {
        throw new NotImplementedException();
    }

    public void sort(int attIndex) {
        throw new NotImplementedException();
    }

    public void stableSort(int attIndex) {
        throw new NotImplementedException();
    }

    public AttributeStats attributeStats(int index) {
        AttributeStats result = new AttributeStats();
        if (this.attribute(index).isNominal()) {
            result.nominalCounts = new int[this.attribute(index).numValues()];
            result.nominalWeights = new double[this.attribute(index).numValues()];
        }
        if (this.attribute(index).isNumeric()) {
            result.numericStats = new Stats();
        }
        result.totalCount = this.numInstances();
        HashMap<Double, double[]> map = new HashMap<Double, double[]>(2 * result.totalCount);
        for (int i = 0; i < this.numInstances(); ++i) {
            Instance current = this.instance(i);
            double key = current.value(index);
            if (Utils.isMissingValue((double)key)) {
                ++result.missingCount;
                continue;
            }
            double[] values = (double[])map.get(key);
            if (values == null) {
                values = new double[]{1.0, current.weight()};
                map.put(key, values);
                continue;
            }
            values[0] = values[0] + 1.0;
            values[1] = values[1] + current.weight();
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addDistinct(((Double)entry.getKey()).doubleValue(), (int)((double[])entry.getValue())[0], ((double[])entry.getValue())[1]);
        }
        return result;
    }

    protected void stratStep(int numFolds) {
        throw new NotImplementedException();
    }

    public void setClassIndex(int classIndex) {
        super.setClassIndex(classIndex);
        this.m_Dataset.setClassIndex(classIndex);
    }
}

