/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;

public class MatrixHelper {
    public static Matrix getX(Instances instances) {
        int clsIndex = instances.classIndex();
        double[][] x = new double[instances.numInstances()][];
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] values = instances.instance(i).toDoubleArray();
            x[i] = new double[values.length - 1];
            int j = 0;
            for (int n = 0; n < values.length; ++n) {
                if (n == clsIndex) continue;
                x[i][j] = values[n];
                ++j;
            }
        }
        Matrix result = new Matrix((double[][])x);
        return result;
    }

    public static Matrix getX(Instance instance) {
        double[][] x = new double[1][];
        double[] values = instance.toDoubleArray();
        x[0] = new double[values.length - 1];
        System.arraycopy(values, 0, x[0], 0, values.length - 1);
        Matrix result = new Matrix((double[][])x);
        return result;
    }

    public static Matrix getY(Instances instances) {
        return MatrixHelper.getY(instances, new int[]{instances.classIndex()});
    }

    public static Matrix getY(Instances instances, int[] cols) {
        double[][] y = new double[instances.numInstances()][cols.length];
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int n = 0; n < cols.length; ++n) {
                y[i][n] = instances.instance(i).classValue();
            }
        }
        Matrix result = new Matrix(y);
        return result;
    }

    public static Matrix getY(Instance instance) {
        double[][] y = new double[1][1];
        y[0][0] = instance.classValue();
        Matrix result = new Matrix(y);
        return result;
    }

    public static Instances toInstances(Instances header, Matrix x, Matrix y) {
        Instances result = new Instances(header, 0);
        int rows = x.getRowDimension();
        int cols = x.getColumnDimension();
        int clsIdx = header.classIndex();
        for (int i = 0; i < rows; ++i) {
            double[] values = new double[cols + 1];
            int offset = 0;
            for (int n = 0; n < values.length; ++n) {
                if (n == clsIdx) {
                    --offset;
                    values[n] = y.get(i, 0);
                    continue;
                }
                values[n] = x.get(i, n + offset);
            }
            result.add((Instance)new DenseInstance(1.0, values));
        }
        return result;
    }

    public static Matrix columnAsVector(Matrix m, int columnIndex) {
        Matrix result = new Matrix(m.getRowDimension(), 1);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            result.set(i, 0, m.get(i, columnIndex));
        }
        return result;
    }

    public static void setVector(Matrix v, Matrix m, int columnIndex) {
        m.setMatrix(0, m.getRowDimension() - 1, columnIndex, columnIndex, v);
    }

    public static Matrix getVector(Matrix m, int columnIndex) {
        return m.getMatrix(0, m.getRowDimension() - 1, columnIndex, columnIndex);
    }

    public static Matrix getDominantEigenVector(Matrix m) {
        EigenvalueDecomposition eigendecomp = m.eig();
        double[] eigenvalues = eigendecomp.getRealEigenvalues();
        int index = Utils.maxIndex((double[])eigenvalues);
        Matrix result = MatrixHelper.columnAsVector(eigendecomp.getV(), index);
        return result;
    }

    public static void normalizeVector(Matrix v) {
        int i;
        double sum = 0.0;
        for (i = 0; i < v.getRowDimension(); ++i) {
            sum += v.get(i, 0) * v.get(i, 0);
        }
        sum = StrictMath.sqrt(sum);
        for (i = 0; i < v.getRowDimension(); ++i) {
            v.set(i, 0, v.get(i, 0) / sum);
        }
    }

    public static boolean equal(Matrix m1, Matrix m2) {
        return MatrixHelper.equal(m1, m2, 0.0);
    }

    public static boolean equal(Matrix m1, Matrix m2, double epsilon) {
        if (m1.getColumnDimension() != m2.getColumnDimension()) {
            return false;
        }
        if (m1.getRowDimension() != m2.getRowDimension()) {
            return false;
        }
        for (int i = 0; i < m1.getRowDimension(); ++i) {
            for (int n = 0; n < m1.getColumnDimension(); ++n) {
                if (!(Math.abs(m1.get(i, n) - m2.get(i, n)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }
}

