/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import adams.core.option.OptionUtils;
import adams.data.weka.rowfinder.ByLabel;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.supervised.attribute.PLS;
import weka.filters.unsupervised.instance.DatasetCleaner;

public class FilteredFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = 2750612199034543886L;
    protected Filter m_PreFilter = this.getDefaultPreFilter();
    protected Filter m_MainFilter = this.getDefaultMainFilter();

    public String globalInfo() {
        return "First applies the pre-filter to the data and the generated data is fed into the main filter. It is possible to apply the pre-filter only during the first batch ('training time').";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tFull class name of pre-filter to use, followed by scheme options.\n\t(default: " + this.getDefaultPreFilter().getClass().getName() + ")", "pre", 1, "-pre <filter specification>"));
        result.addElement(new Option("\tFull class name of main filter to use, followed by scheme options.\n\t(default: " + this.getDefaultMainFilter().getClass().getName() + ")", "main", 1, "-main <filter specification>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"pre", (String[])options);
        if (tmpStr.length() == 0) {
            tmpStr = this.getDefaultPreFilter().getClass().getName();
        }
        this.setPreFilter((Filter)OptionUtils.forAnyCommandLine(Filter.class, (String)tmpStr));
        tmpStr = Utils.getOption((String)"main", (String[])options);
        if (tmpStr.length() == 0) {
            tmpStr = this.getDefaultMainFilter().getClass().getName();
        }
        this.setMainFilter((Filter)OptionUtils.forAnyCommandLine(Filter.class, (String)tmpStr));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-pre");
        result.add(OptionUtils.getCommandLine((Object)this.getPreFilter()));
        result.add("-main");
        result.add(OptionUtils.getCommandLine((Object)this.getMainFilter()));
        return result.toArray(new String[result.size()]);
    }

    public Capabilities getCapabilities() {
        return this.m_PreFilter.getCapabilities();
    }

    public boolean mayRemoveInstanceAfterFirstBatchDone() {
        return false;
    }

    protected Filter getDefaultPreFilter() {
        DatasetCleaner result = new DatasetCleaner();
        result.setRowFinder(new ByLabel());
        return result;
    }

    public void setPreFilter(Filter value) {
        this.m_PreFilter = value;
        this.reset();
    }

    public Filter getPreFilter() {
        return this.m_PreFilter;
    }

    public String preFilterTipText() {
        return "The filter to generate the filtered to feed into the main filter.";
    }

    protected Filter getDefaultMainFilter() {
        return new PLS();
    }

    public void setMainFilter(Filter value) {
        this.m_MainFilter = value;
        this.reset();
    }

    public Filter getMainFilter() {
        return this.m_MainFilter;
    }

    public String mainFilterTipText() {
        return "The actual filter to use, uses the pre-filtered data.";
    }

    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_PreFilter.setInputFormat(inputFormat);
        Instances tmp = Filter.useFilter((Instances)inputFormat, (Filter)this.m_PreFilter);
        if (!tmp.equalHeaders(inputFormat)) {
            throw new IllegalStateException("Pre-filter alters the dataset structure!");
        }
        this.m_MainFilter.setInputFormat(inputFormat);
        tmp = Filter.useFilter((Instances)inputFormat, (Filter)this.m_MainFilter);
        Instances result = new Instances(tmp, 0);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.m_PreFilter.setInputFormat(instances);
            Instances reduced = Filter.useFilter((Instances)instances, (Filter)this.m_PreFilter);
            this.m_MainFilter.setInputFormat(reduced);
            Filter.useFilter((Instances)reduced, (Filter)this.m_MainFilter);
        }
        Instances result = Filter.useFilter((Instances)instances, (Filter)this.m_MainFilter);
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 15155 $");
    }

    public static void main(String[] args) {
        FilteredFilter.runFilter((Filter)new FilteredFilter(), (String[])args);
    }
}

