/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import adams.core.option.OptionHandler;
import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.PLS1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.GenericPLSMatrixAccess;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.SupervisedFilter;

public class PLS
extends SimpleBatchFilter
implements SupervisedFilter,
TechnicalInformationHandler,
GenericPLSMatrixAccess {
    static final long serialVersionUID = -3335106965521265631L;
    protected AbstractPLS m_Algorithm = this.getDefaultAlgorithm();

    public String globalInfo() {
        return "Applies the specified partial least squares (PLS) algorithm to the data.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tormod Naes and Tomas Isaksson and Tom Fearn and Tony Davies");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "A User Friendly Guide to Multivariate Calibration and Classification");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "NIR Publications");
        result.setValue(TechnicalInformation.Field.ISBN, "0-9528666-2-5");
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.algorithmTipText(), this.getDefaultAlgorithm().getClass().getName(), "algorithm");
        WekaOptionUtils.add(result, super.listOptions());
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, "algorithm", (OptionHandler)this.getAlgorithm());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        this.setAlgorithm((AbstractPLS)WekaOptionUtils.parse(options, "algorithm", (OptionHandler)this.getDefaultAlgorithm()));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected AbstractPLS getDefaultAlgorithm() {
        return new PLS1();
    }

    public void setAlgorithm(AbstractPLS value) {
        this.m_Algorithm = value;
    }

    public AbstractPLS getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The PLS algorithm to apply.";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return this.m_Algorithm.determineOutputFormat(inputFormat);
    }

    public Capabilities getCapabilities() {
        return this.m_Algorithm.getCapabilities();
    }

    protected Instances process(Instances instances) throws Exception {
        return this.m_Algorithm.transform(instances);
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_Algorithm.getMatrixNames();
    }

    @Override
    public Matrix getMatrix(String name) {
        return this.m_Algorithm.getMatrix(name);
    }

    @Override
    public boolean hasLoadings() {
        return this.m_Algorithm.hasLoadings();
    }

    @Override
    public Matrix getLoadings() {
        return this.m_Algorithm.getLoadings();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10364 $");
    }

    public static void main(String[] args) {
        PLS.runFilter((Filter)new PLS(), (String[])args);
    }
}

