/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import adams.core.Utils;
import adams.core.discovery.genetic.WekaGeneticHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.WekaOptionUtils;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

public class SIMPLSMatrixFilterFromGeneticString
extends PLSFilter {
    private static final long serialVersionUID = -5366730549674709661L;
    protected Matrix m_SIMPLS_MATRIX_LOCAL = null;
    public static final String BITSTRING = "bitstring";
    protected String m_BitString = "1";
    public static final String MIN = "min";
    protected double m_Min;
    public static final String MAX = "max";
    protected double m_Max;
    public static final String SPLITS = "splits";
    protected int m_Splits;
    public static final String COLUMNS = "columns";
    protected int m_Columns;
    public static final String ROWS = "rows";
    protected int m_Rows;

    public void setBitstring(String bits) {
        this.m_BitString = bits;
        this.reset();
    }

    public String getBitstring() {
        return this.m_BitString;
    }

    public String bitstringTipText() {
        return "Bitstring from genetic algorithm";
    }

    public void setMin(double min) {
        this.m_Min = min;
        this.reset();
    }

    public double getMin() {
        return this.m_Min;
    }

    public String minTipText() {
        return "Min double from genetic algorithm";
    }

    public void setMax(double max) {
        this.m_Max = max;
        this.reset();
    }

    public double getMax() {
        return this.m_Max;
    }

    public String maxTipText() {
        return "Max double from genetic algorithm";
    }

    public void setSplits(int splits) {
        this.m_Splits = splits;
        this.reset();
    }

    public int getSplits() {
        return this.m_Splits;
    }

    public String splitsTipText() {
        return "Splits from genetic algorithm";
    }

    public void setRows(int rows) {
        this.m_Rows = rows;
        this.reset();
    }

    public int getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "Rows from genetic algorithm";
    }

    public void setColumns(int columns) {
        this.m_Columns = columns;
        this.reset();
    }

    public int getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "Columns from genetic algorithm";
    }

    public void initialiseWeights() {
        this.m_SIMPLS_MATRIX_LOCAL = null;
    }

    public void initialiseW(Instances ins) throws Exception {
        this.m_SIMPLS_MATRIX_LOCAL = WekaGeneticHelper.bitsToMatrix(this.m_BitString, this.m_Min, this.m_Max, this.calcNumBits(), this.m_Splits, this.m_Rows, this.m_Columns);
    }

    protected int calcNumBits() {
        return (int)(Math.floor(Utils.log2((int)this.m_Splits)) + 1.0);
    }

    public void setMatrix(Matrix m) {
        this.m_SIMPLS_MATRIX_LOCAL = m;
    }

    public Matrix getMatrix() {
        return this.m_SIMPLS_MATRIX_LOCAL;
    }

    protected Instances processSIMPLS(Instances instances) throws Exception {
        if (this.m_SIMPLS_MATRIX_LOCAL == null) {
            this.initialiseW(instances);
        }
        Instances result = new Instances(this.getOutputFormat());
        Matrix X = this.getX(instances);
        Matrix X_new = X.times(this.m_SIMPLS_MATRIX_LOCAL);
        Matrix y = this.getY(instances);
        result = this.toInstances(this.getOutputFormat(), X_new, y);
        return result;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.bitstringTipText(), "1", BITSTRING);
        WekaOptionUtils.addOption(result, this.minTipText(), "0.0", MIN);
        WekaOptionUtils.addOption(result, this.maxTipText(), "0.0", MAX);
        WekaOptionUtils.addOption(result, this.splitsTipText(), "1", SPLITS);
        WekaOptionUtils.addOption(result, this.rowsTipText(), "1", ROWS);
        WekaOptionUtils.addOption(result, this.columnsTipText(), "1", COLUMNS);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setBitstring(WekaOptionUtils.parse(options, BITSTRING, "1"));
        this.setMin(WekaOptionUtils.parse(options, MIN, 0.0));
        this.setMax(WekaOptionUtils.parse(options, MAX, 0.0));
        this.setSplits(WekaOptionUtils.parse(options, SPLITS, 1));
        this.setRows(WekaOptionUtils.parse(options, ROWS, 1));
        this.setColumns(WekaOptionUtils.parse(options, COLUMNS, 1));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, BITSTRING, this.getBitstring());
        WekaOptionUtils.add(result, MIN, this.getMin());
        WekaOptionUtils.add(result, MAX, this.getMax());
        WekaOptionUtils.add(result, SPLITS, this.getSplits());
        WekaOptionUtils.add(result, ROWS, this.getRows());
        WekaOptionUtils.add(result, COLUMNS, this.getColumns());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public String globalInfo() {
        return "";
    }

    protected void reset() {
        super.reset();
        this.m_SIMPLS_MATRIX_LOCAL = null;
    }

    public static void main(String[] args) {
        SIMPLSMatrixFilterFromGeneticString.runFilter((Filter)new SIMPLSMatrixFilterFromGeneticString(), (String[])args);
    }
}

