/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.statistics.StatCalc;
import adams.data.utils.SAXUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class PAA
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -3516731512819723355L;
    protected int m_windows = 80;

    public String globalInfo() {
        return "Piecewise Aggregate Approximation.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tNumber of windows for PAA (>1).\n\t(default: 80)", "windows", 80, "-windows <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"windows", (String[])options);
        if (tmpStr.length() > 0) {
            this.setWindows(Integer.parseInt(tmpStr));
        } else {
            this.setWindows(80);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-windows");
        result.add("" + this.getWindows());
        return result.toArray(new String[result.size()]);
    }

    public void setWindows(int value) {
        if (value > 0) {
            this.m_windows = value;
            this.reset();
        } else {
            System.err.println("'n' must be larger than 0 (provided: " + value + ")!");
        }
    }

    public int getWindows() {
        return this.m_windows;
    }

    public String windowsPointTipText() {
        return "number of windows for PAA (>0).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        boolean hasClass = inputFormat.classIndex() > -1;
        FastVector values = new FastVector();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        boolean count = false;
        for (int i = 0; i < this.getWindows(); ++i) {
            atts.add(new Attribute("PAA_" + (i + 1)));
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected double[] getMeanStdev(Instance in) {
        double[] ret = new double[2];
        StatCalc st = new StatCalc();
        for (int i = 0; i < in.numAttributes(); ++i) {
            if (i == in.classIndex()) continue;
            st.enter(in.value(i));
        }
        ret[0] = st.getMean();
        ret[1] = st.getStandardDeviation();
        return ret;
    }

    protected Instance process(Instance instance) throws Exception {
        if (this.getDebug()) {
            double[] stats = this.getMeanStdev(instance);
            System.err.println("Instance mean=" + stats[0] + ", sd=" + stats[1]);
        }
        boolean hasClass = instance.classIndex() > -1;
        double[] ivals = new double[instance.numAttributes() - 1];
        int count = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            ivals[count] = instance.value(i);
            ++count;
        }
        double[] paavalues = SAXUtils.PAA((double[])ivals, (int)this.getWindows());
        double[] values = new double[this.getOutputFormat().numAttributes()];
        for (int i = 0; i < paavalues.length; ++i) {
            values[i] = paavalues[i];
        }
        if (hasClass) {
            values[values.length - 1] = instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.getOutputFormat());
        this.copyValues((Instance)result, false, instance.dataset(), this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 15058 $");
    }

    public static void main(String[] args) {
        PAA.runFilter((Filter)new PAA(), (String[])args);
    }
}

