/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClustererSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaTrainClusterer;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;

public class WekaClustererSetupTest
extends AbstractFlowTest {
    public WekaClustererSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        WekaClustererSetup cls = new WekaClustererSetup();
        cls.setName("cls");
        cls.setClusterer((Clusterer)new SimpleKMeans());
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaTrainClusterer cl = new WekaTrainClusterer();
        cl.setClusterer(new CallableActorReference("cls"));
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sfs, fr, cl, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaClustererSetupTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClustererSetupTest.runTest((Test)WekaClustererSetupTest.suite());
    }
}

