/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AnyToCommandline;
import adams.data.conversion.Conversion;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.SequenceSource;
import adams.flow.source.WekaClassifierGenerator;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.Convert;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifierRanker;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.MathParameter;

public class WekaClassifierRankerTest
extends AbstractFlowTest {
    public WekaClassifierRankerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        SequenceSource seq = new SequenceSource();
        seq.setName("dataset");
        seq.setActors(new Actor[]{sfs, fr, cs});
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{seq});
        WekaClassifierGenerator cg = new WekaClassifierGenerator();
        cg.setOutputArray(true);
        cg.setSetup((Classifier)new J48());
        MathParameter param = new MathParameter();
        param.setProperty("confidenceFactor");
        param.setBase(10.0);
        param.setMin(0.1);
        param.setMax(0.5);
        param.setStep(0.1);
        cg.setParameters(new AbstractParameter[]{param});
        WekaClassifierRanker cr = new WekaClassifierRanker();
        cr.setNumThreads(1);
        cr.setMax(3);
        cr.setFolds(10);
        cr.setMeasure(WekaClassifierRanker.Measure.ACC);
        cr.setTrain(new CallableActorReference("dataset"));
        ArrayToSequence a2s = new ArrayToSequence();
        Convert conv = new Convert();
        AnyToCommandline a2c = new AnyToCommandline();
        conv.setConversion((Conversion)a2c);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, cg, cr, a2s, conv, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaClassifierRankerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClassifierRankerTest.runTest((Test)WekaClassifierRankerTest.suite());
    }
}

