/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationInfo;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.classifiers.trees.J48;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.SimpleArffLoader;

public class WekaEvaluationInfoTest
extends AbstractFlowTest {
    public WekaEvaluationInfoTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("anneal.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("anneal.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaEvaluationInfoTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            CallableActors callableactors = new CallableActors();
            ArrayList<WekaClassifierSetup> actors2 = new ArrayList<WekaClassifierSetup>();
            WekaClassifierSetup wekaclassifiersetup = new WekaClassifierSetup();
            J48 j48 = new J48();
            j48.setOptions(OptionUtils.splitOptions((String)"-C 0.25 -M 2"));
            wekaclassifiersetup.setClassifier((Classifier)j48);
            actors2.add(wekaclassifiersetup);
            callableactors.setActors(actors2.toArray(new Actor[0]));
            actors.add(callableactors);
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/anneal.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            WekaFileReader wekafilereader = new WekaFileReader();
            SimpleArffLoader simplearffloader = new SimpleArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)simplearffloader);
            actors.add(wekafilereader);
            WekaClassSelector wekaclassselector = new WekaClassSelector();
            actors.add(wekaclassselector);
            WekaCrossValidationEvaluator wekacrossvalidationevaluator = new WekaCrossValidationEvaluator();
            Null null_ = new Null();
            wekacrossvalidationevaluator.setOutput((AbstractOutput)null_);
            actors.add(wekacrossvalidationevaluator);
            WekaEvaluationInfo wekaevaluationinfo = new WekaEvaluationInfo();
            argOption = (AbstractArgumentOption)wekaevaluationinfo.getOptionManager().findByProperty("type");
            wekaevaluationinfo.setType((WekaEvaluationInfo.InfoType)argOption.valueOf("NUM_PREDICTIONS"));
            actors.add(wekaevaluationinfo);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WekaEvaluationInfoTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaEvaluationInfoTest.runTest((Test)WekaEvaluationInfoTest.suite());
    }
}

