/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.WekaEvaluationToThresholdCurve;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaEvaluationToThresholdCurveTest
extends AbstractConversionTestCase {
    public WekaEvaluationToThresholdCurveTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.csv");
        super.tearDown();
    }

    protected String toString(Object data) {
        String result;
        Instances inst = (Instances)data;
        WekaInstancesToSpreadSheet conv = new WekaInstancesToSpreadSheet();
        conv.setInput((Object)inst);
        String msg = conv.convert();
        if (msg == null) {
            SpreadSheet sheet = (SpreadSheet)conv.getOutput();
            StringWriter swriter = new StringWriter();
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            writer.setNumberFormat("0.000000");
            writer.write(sheet, (Writer)swriter);
            result = swriter.toString();
        } else {
            result = null;
        }
        conv.cleanUp();
        return result;
    }

    protected Object[] getRegressionInput() {
        Evaluation[] result;
        try {
            Instances data = ConverterUtils.DataSource.read((String)new TmpFile("labor.csv").getAbsolutePath());
            data.setClassIndex(data.numAttributes() - 1);
            result = new Evaluation[]{new Evaluation(data)};
            result[0].crossValidateModel((Classifier)new J48(), data, 10, new Random(1L));
        }
        catch (Exception e) {
            result = null;
            WekaEvaluationToThresholdCurveTest.fail((String)Utils.throwableToString((Throwable)e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        WekaEvaluationToThresholdCurve[] result = new WekaEvaluationToThresholdCurve[]{new WekaEvaluationToThresholdCurve()};
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public void testRegression() {
    }

    public static Test suite() {
        return new TestSuite(WekaEvaluationToThresholdCurveTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaEvaluationToThresholdCurveTest.runTest((Test)WekaEvaluationToThresholdCurveTest.suite());
    }
}

