/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.NamedSetup;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class NamedSetupTest
extends AbstractFlowTest {
    public NamedSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        WekaClassifierSetup cls = new WekaClassifierSetup();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new CallableActorReference("cls"));
        WekaEvaluationSummary eval = new WekaEvaluationSummary();
        NamedSetup named = new NamedSetup();
        named.setSetup(new adams.core.NamedSetup("sink_dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sfs, fr, cs, cv, eval, named});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(NamedSetupTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        NamedSetupTest.runTest((Test)NamedSetupTest.suite());
    }
}

