/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.data.conversion.Conversion;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.container.AbstractContainer;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.MakeContainer;
import adams.flow.source.SequenceSource;
import adams.flow.source.WekaClustererSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SetStorageValue;
import adams.flow.transformer.WekaClusterAssignments;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.WekaTrainTestSetClustererEvaluator;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WekaClusterAssignmentsTest
extends AbstractFlowTest {
    public WekaClusterAssignmentsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("anneal_train.arff");
        this.m_TestHelper.copyResourceToTmp("anneal_test.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("anneal_train.arff");
        this.m_TestHelper.deleteFileFromTmp("anneal_test.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(WekaClusterAssignmentsTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            CallableActors callableactors = new CallableActors();
            ArrayList<Object> actors2 = new ArrayList<Object>();
            WekaClustererSetup wekaclusterersetup = new WekaClustererSetup();
            SimpleKMeans simplekmeans = new SimpleKMeans();
            simplekmeans.setOptions(OptionUtils.splitOptions((String)"-init 0 -max-candidates 100 -periodic-pruning 10000 -min-density 2.0 -t1 -1.25 -t2 -1.0 -N 2 -A \"weka.core.EuclideanDistance -R first-last\" -I 500 -num-slots 1 -S 10"));
            wekaclusterersetup.setClusterer((Clusterer)simplekmeans);
            actors2.add(wekaclusterersetup);
            SequenceSource sequencesource = new SequenceSource();
            AbstractArgumentOption argOption = (AbstractArgumentOption)sequencesource.getOptionManager().findByProperty("name");
            sequencesource.setName((String)argOption.valueOf("train"));
            ArrayList<Object> actors3 = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/anneal_train.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors3.add(filesupplier);
            WekaFileReader wekafilereader = new WekaFileReader();
            ArffLoader arffloader = new ArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)arffloader);
            actors3.add(wekafilereader);
            WekaFilter wekafilter = new WekaFilter();
            Remove remove = new Remove();
            remove.setOptions(OptionUtils.splitOptions((String)"-R last"));
            wekafilter.setFilter((Filter)remove);
            actors3.add(wekafilter);
            sequencesource.setActors(actors3.toArray(new Actor[0]));
            actors2.add(sequencesource);
            SequenceSource sequencesource2 = new SequenceSource();
            argOption = (AbstractArgumentOption)sequencesource2.getOptionManager().findByProperty("name");
            sequencesource2.setName((String)argOption.valueOf("test"));
            ArrayList<Object> actors4 = new ArrayList<Object>();
            FileSupplier filesupplier2 = new FileSupplier();
            argOption = (AbstractArgumentOption)filesupplier2.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files2 = new ArrayList<PlaceholderFile>();
            files2.add((PlaceholderFile)argOption.valueOf("${TMP}/anneal_test.arff"));
            filesupplier2.setFiles(files2.toArray(new PlaceholderFile[0]));
            actors4.add(filesupplier2);
            WekaFileReader wekafilereader2 = new WekaFileReader();
            ArffLoader arffloader2 = new ArffLoader();
            wekafilereader2.setCustomLoader((AbstractFileLoader)arffloader2);
            actors4.add(wekafilereader2);
            WekaFilter wekafilter2 = new WekaFilter();
            Remove remove2 = new Remove();
            remove2.setOptions(OptionUtils.splitOptions((String)"-R last"));
            wekafilter2.setFilter((Filter)remove2);
            actors4.add(wekafilter2);
            Tee tee = new Tee();
            argOption = (AbstractArgumentOption)tee.getOptionManager().findByProperty("name");
            tee.setName((String)argOption.valueOf("put spreadsheet in storage"));
            ArrayList<Object> actors5 = new ArrayList<Object>();
            Convert convert = new Convert();
            WekaInstancesToSpreadSheet wekainstancestospreadsheet = new WekaInstancesToSpreadSheet();
            DenseDataRow densedatarow = new DenseDataRow();
            wekainstancestospreadsheet.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            wekainstancestospreadsheet.setSpreadSheetType((SpreadSheet)defaultspreadsheet);
            convert.setConversion((Conversion)wekainstancestospreadsheet);
            actors5.add(convert);
            SetStorageValue setstoragevalue = new SetStorageValue();
            argOption = (AbstractArgumentOption)setstoragevalue.getOptionManager().findByProperty("storageName");
            setstoragevalue.setStorageName((StorageName)argOption.valueOf("test"));
            actors5.add(setstoragevalue);
            tee.setActors(actors5.toArray(new Actor[0]));
            actors4.add(tee);
            sequencesource2.setActors(actors4.toArray(new Actor[0]));
            actors2.add(sequencesource2);
            callableactors.setActors(actors2.toArray(new Actor[0]));
            actors.add(callableactors);
            MakeContainer makecontainer = new MakeContainer();
            argOption = (AbstractArgumentOption)makecontainer.getOptionManager().findByProperty("callableActors");
            ArrayList<CallableActorReference> callableactors2 = new ArrayList<CallableActorReference>();
            callableactors2.add((CallableActorReference)argOption.valueOf("train"));
            callableactors2.add((CallableActorReference)argOption.valueOf("test"));
            makecontainer.setCallableActors(callableactors2.toArray(new CallableActorReference[0]));
            argOption = (AbstractArgumentOption)makecontainer.getOptionManager().findByProperty("valueNames");
            ArrayList<BaseString> valuenames = new ArrayList<BaseString>();
            valuenames.add((BaseString)argOption.valueOf("Train"));
            valuenames.add((BaseString)argOption.valueOf("Test"));
            makecontainer.setValueNames(valuenames.toArray(new BaseString[0]));
            WekaTrainTestSetContainer wekatraintestsetcontainer = new WekaTrainTestSetContainer();
            makecontainer.setContainerClass((AbstractContainer)wekatraintestsetcontainer);
            actors.add(makecontainer);
            WekaTrainTestSetClustererEvaluator wekatraintestsetclustererevaluator = new WekaTrainTestSetClustererEvaluator();
            wekatraintestsetclustererevaluator.setOutputModel(true);
            actors.add(wekatraintestsetclustererevaluator);
            WekaClusterAssignments wekaclusterassignments = new WekaClusterAssignments();
            actors.add(wekaclusterassignments);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WekaClusterAssignmentsTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClusterAssignmentsTest.runTest((Test)WekaClusterAssignmentsTest.suite());
    }
}

