/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import weka.classifiers.AbstractSplitGenerator;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public abstract class AbstractSplitGeneratorTestCase
extends AdamsTestCase {
    public AbstractSplitGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "weka/classifiers/data");
    }

    protected Instances load(String filename) {
        Instances result;
        this.m_TestHelper.copyResourceToTmp(filename);
        try {
            result = ConverterUtils.DataSource.read((String)new TmpFile(filename).getAbsolutePath());
            result.setClassIndex(result.numAttributes() - 1);
        }
        catch (Exception e) {
            result = null;
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected boolean save(WekaTrainTestSetContainer data, String filename) {
        return FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)data, (boolean)false);
    }

    protected abstract AbstractSplitGenerator[] getRegressionSetups();

    protected String createOutputFilename(int no, int sub) {
        return "out-" + no + "-" + sub + ".txt";
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        AbstractSplitGenerator[] setups = this.getRegressionSetups();
        ArrayList<TmpFile> outputFiles = new ArrayList<TmpFile>();
        for (i = 0; i < setups.length; ++i) {
            int count = 0;
            while (setups[i].hasNext()) {
                WekaTrainTestSetContainer cont;
                try {
                    cont = setups[i].next();
                    AbstractSplitGeneratorTestCase.assertNotNull((String)("Failed to generate data (" + (i + 1) + "/" + (count + 1) + ")?"), (Object)cont);
                }
                catch (Exception e) {
                    AbstractSplitGeneratorTestCase.fail((String)("Failed to generate data (" + (i + 1) + "/" + (count + 1) + "): " + Utils.throwableToString((Throwable)e)));
                    continue;
                }
                String output = this.createOutputFilename(i, count);
                outputFiles.add(new TmpFile(output));
                boolean ok = this.save(cont, output);
                AbstractSplitGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
                ++count;
            }
        }
        String regression = this.m_Regression.compare((File[])outputFiles.toArray(new TmpFile[outputFiles.size()]));
        AbstractSplitGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < setups.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
                continue;
            }
            if (!(setups[i] instanceof CleanUpHandler)) continue;
            ((CleanUpHandler)setups[i]).cleanUp();
        }
        for (i = 0; i < outputFiles.size(); ++i) {
            ((TmpFile)outputFiles.get(i)).delete();
        }
    }
}

