/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.data.conversion.AnyToCommandline;
import adams.data.conversion.Conversion;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.WekaAssociatorSetup;
import adams.flow.transformer.Convert;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.associations.Apriori;
import weka.associations.Associator;

public class WekaAssociatorSetupTest
extends AbstractFlowTest {
    public WekaAssociatorSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaAssociatorSetupTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            WekaAssociatorSetup wekaassociatorsetup = new WekaAssociatorSetup();
            Apriori apriori = new Apriori();
            apriori.setOptions(OptionUtils.splitOptions((String)"-N 10 -T 0 -C 0.9 -D 0.05 -U 1.0 -M 0.1 -S -1.0 -c -1 \"\" \"\" \"\" \"\" \"\" \"\" \"\""));
            wekaassociatorsetup.setAssociator((Associator)apriori);
            actors.add(wekaassociatorsetup);
            Convert convert = new Convert();
            AnyToCommandline anytocommandline = new AnyToCommandline();
            convert.setConversion((Conversion)anytocommandline);
            actors.add(convert);
            DumpFile dumpfile = new DumpFile();
            AbstractArgumentOption argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WekaAssociatorSetupTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaAssociatorSetupTest.runTest((Test)WekaAssociatorSetupTest.suite());
    }
}

