/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AnyToCommandline;
import adams.data.conversion.Conversion;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.WekaClassifierGenerator;
import adams.flow.transformer.Convert;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.MathParameter;

public class WekaClassifierGeneratorTest
extends AbstractFlowTest {
    public WekaClassifierGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        WekaClassifierGenerator cg = new WekaClassifierGenerator();
        cg.setSetup((Classifier)new J48());
        MathParameter param = new MathParameter();
        param.setProperty("confidenceFactor");
        param.setMin(0.1);
        param.setMax(0.5);
        param.setStep(0.1);
        param.setExpression("I");
        cg.setParameters(new AbstractParameter[]{param});
        Convert conv = new Convert();
        conv.setConversion((Conversion)new AnyToCommandline());
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{cg, conv, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaClassifierGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClassifierGeneratorTest.runTest((Test)WekaClassifierGeneratorTest.suite());
    }
}

