/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.FlowFile;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ExternalTransformer;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import adams.test.TmpFlowFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.CSVSaver;

public class ExternalTransformerTest
extends AbstractFlowTest {
    public ExternalTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("external_transformer.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("external_transformer.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        ExternalTransformer ext = new ExternalTransformer();
        ext.setActorFile((FlowFile)new TmpFlowFile("external_transformer.flow"));
        WekaFileWriter fw = new WekaFileWriter();
        CSVSaver saver = new CSVSaver();
        fw.setCustomSaver((AbstractFileSaver)saver);
        fw.setUseCustomSaver(true);
        fw.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sfs, fr, cs, ext, fw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(ExternalTransformerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ExternalTransformerTest.runTest((Test)ExternalTransformerTest.suite());
    }
}

